/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRQuery
extends JCRWorkspaceFolderItem
implements Query {
    public JCRQuery(JCRWorkspace workspace, ItemDelegate itemDelegate) throws RepositoryException, InternalErrorException {
        super(workspace, itemDelegate);
    }

    public JCRQuery(JCRWorkspace workspace, ItemDelegate itemDelegate, String name, String description, String query, QueryType queryType) throws RepositoryException {
        super(workspace, itemDelegate, name, description);
        Validate.notNull((Object)query, (String)"Query must be not null");
        Validate.notNull((Object)queryType, (String)"Query Type must be not null");
        Map content = itemDelegate.getContent();
        content.put(NodeProperty.QUERY, query);
        content.put(NodeProperty.QUERY_TYPE, queryType.toString());
    }

    @Override
    public long getLength() throws InternalErrorException {
        return ((String)this.delegate.getContent().get(NodeProperty.QUERY)).length();
    }

    public String getQuery() {
        return (String)this.delegate.getContent().get(NodeProperty.QUERY);
    }

    public QueryType getQueryType() {
        return QueryType.valueOf((String)((String)this.delegate.getContent().get(NodeProperty.QUERY_TYPE)));
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.QUERY;
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        return null;
    }
}

