/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryShare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRAccountingEntryShare
extends JCRAccountingEntry
implements AccountingEntryShare {
    private final String itemName;
    private final List<String> members;
    protected static Logger logger = LoggerFactory.getLogger(JCRAccountingEntryShare.class);

    public JCRAccountingEntryShare(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.itemName = (String)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.ITEM_NAME));
        this.members = (List)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.MEMBERS));
    }

    public JCRAccountingEntryShare(String id, String user, Calendar date, String nodeName, List<String> members) {
        super(id, user, date);
        this.itemName = nodeName;
        this.members = members;
        Map properties = this.entryDelegate.getAccountingProperties();
        properties.put(AccountingProperty.ITEM_NAME, new XStream().toXML((Object)this.itemName));
        String[] array = members.toArray(new String[members.size()]);
        properties.put(AccountingProperty.MEMBERS, new XStream().toXML((Object)array));
        this.entryDelegate.setEntryType(AccountingEntryType.SHARE);
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.SHARE;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s]]", parentValue, this.getEntryType());
    }

    public String getItemName() {
        return this.itemName;
    }

    public List<String> getMembers() {
        return this.members;
    }
}

