/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import ij.ImagePlus;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.Image;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.util.WorkspaceItemUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRImage
extends JCRFile
implements Image {
    private static final String IMAGE_WIDTH = "hl:width";
    private static final String IMAGE_HEIGHT = "hl:height";
    private static final String THUMBNAIL_DATA = "hl:thumbnailData";
    private static final String THUMBNAIL_WIDTH = "hl:thumbnailWidth";
    private static final String THUMBNAIL_HEIGHT = "hl:thumbnailHeight";
    private static final String noPreviewImg = "/no-thumbnail.png";

    public JCRImage(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
    }

    public JCRImage(JCRWorkspace workspace, Node node, InputStream data) throws RepositoryException, IOException, RemoteBackendException {
        super(workspace, node, new BufferedInputStream(data));
        this.setProperties(node);
    }

    private void setProperties(Node node) throws IOException, ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        InputStream dataImage = null;
        int[] thumbnailSize = null;
        InputStream thumbnailStream = null;
        ImagePlus imagePlus = null;
        int width = 0;
        int height = 0;
        try {
            if (this.tmpFile == null) {
                String remotePath = node.getProperty("hl:remotePath").getString();
                dataImage = GCUBEStorage.getRemoteFile(remotePath, this.portalLogin);
            } else {
                dataImage = new FileInputStream(this.tmpFile);
            }
            imagePlus = WorkspaceItemUtil.getImgePlus(dataImage);
            width = imagePlus.getWidth();
            height = imagePlus.getHeight();
            thumbnailSize = WorkspaceItemUtil.getThumbnailDimension(width, height);
            thumbnailStream = WorkspaceItemUtil.getThumbnailAsPng(imagePlus, thumbnailSize);
        }
        catch (Exception e) {
            dataImage = JCRImage.class.getResourceAsStream(noPreviewImg);
            imagePlus = WorkspaceItemUtil.getImgePlus(dataImage);
            width = imagePlus.getWidth();
            height = imagePlus.getHeight();
            thumbnailSize[0] = width;
            thumbnailSize[1] = height;
            thumbnailStream = JCRImage.class.getResourceAsStream(noPreviewImg);
        }
        Binary binary = node.getSession().getValueFactory().createBinary(thumbnailStream);
        node.setProperty(IMAGE_WIDTH, (long)width);
        node.setProperty(IMAGE_HEIGHT, (long)height);
        node.setProperty(THUMBNAIL_WIDTH, (long)thumbnailSize[0]);
        node.setProperty(THUMBNAIL_HEIGHT, (long)thumbnailSize[1]);
        node.setProperty(THUMBNAIL_DATA, binary);
        thumbnailStream.close();
        imagePlus.close();
        dataImage.close();
    }

    public int getWidth() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(IMAGE_WIDTH).getLong();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public int getHeight() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(IMAGE_HEIGHT).getLong();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public InputStream getThumbnail() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            InputStream inputStream = node.getProperty(THUMBNAIL_DATA).getBinary().getStream();
            return inputStream;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public int getThumbnailWidth() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(THUMBNAIL_WIDTH).getLong();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public int getThumbnailHeight() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(THUMBNAIL_HEIGHT).getLong();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public long getThumbnailLength() throws InternalErrorException {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            long l = node.getProperty(THUMBNAIL_DATA).getBinary().getSize();
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public void updateInfo(String mimeType) throws InternalErrorException {
        super.updateInfo(mimeType);
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            this.setProperties(node);
            session.save();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }
}

