/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryShare;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryType;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRAccountingEntryModifyACL
extends JCRAccountingEntry
implements AccountingEntryShare {
    private static final String MEMBERS = "hl:members";
    private static final String ITEM_NAME = "hl:itemName";
    protected String itemName;
    protected List<String> members;
    protected static Logger logger = LoggerFactory.getLogger(JCRAccountingEntryModifyACL.class);

    public JCRAccountingEntryModifyACL(Node node) throws RepositoryException {
        super(node);
        this.itemName = node.getProperty(ITEM_NAME).getString();
        this.members = new ArrayList<String>();
        for (Value v : node.getProperty(MEMBERS).getValues()) {
            if (v == null) continue;
            this.members.add(v.toString());
        }
    }

    public JCRAccountingEntryModifyACL(String user, Calendar date, String nodeName, List<String> members) {
        super(user, date);
        this.itemName = nodeName;
        this.members = members;
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.SHARE;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s]]", parentValue, this.getEntryType());
    }

    @Override
    public void save(Node entryNode) throws RepositoryException {
        super.save(entryNode);
        entryNode.setProperty(ITEM_NAME, this.itemName);
        String[] array = this.members.toArray(new String[this.members.size()]);
        entryNode.setProperty(MEMBERS, array);
        entryNode.getSession().save();
    }

    public String getItemName() {
        return this.itemName;
    }

    public List<String> getMembers() {
        return this.members;
    }
}

