package org.gcube.common.homelibrary.jcr.workspace.accessmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.accessmanager.AccessManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.thoughtworks.xstream.XStream;

public class JCRAccessManager implements AccessManager{

	private Logger logger = LoggerFactory.getLogger(JCRAccessManager.class);

	public static final String JUST_OWNER 				= "hl:justOwner";

	public static String url;

	public JCRAccessManager(){
		super();
		url = JCRRepository.url;
	}



	public Map<String, List<String>> getACL(String absPath) throws InternalErrorException {

		Session session = JCRRepository.getSession();

		List<AccessControlEntry> allEntries = null;
		try {
			allEntries = new ArrayList<AccessControlEntry>(); 

			AccessControlManager accessControlManager = session.getAccessControlManager();
			AccessControlPolicy[] policies = accessControlManager.getPolicies(absPath);

			for (AccessControlPolicy accessControlPolicy : policies) {
				if (accessControlPolicy instanceof AccessControlList) {
					AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
					for (AccessControlEntry accessControlEntry : accessControlEntries) {
						allEntries.add(accessControlEntry);
					}
				}
			}
		} catch (RepositoryException e) {
			logger.error("Error getting ACL in AccessManager for node: " +  absPath, e);
			throw new InternalErrorException(e);
		}


		Map<String, List<String>> map = getMap(allEntries);


		return map;

	}


	public void modifyAce(List<String> users, String absPath,
			List<String> privilegesList, String order) throws InternalErrorException {

		try{
			deleteAces(absPath, users);
		}catch (Exception e) {
			logger.error("Error deleting old ACLs: " + e);
			throw new InternalErrorException(e);
		}

		GetMethod getMethod = null;
		try {

			HttpClient httpClient = new HttpClient();      		

			StringBuilder privileges= new StringBuilder();
			for (String privilege: privilegesList){	
				privileges.append("&privilege@" + privilege);
			}

			if(order == null)
				order = "first";

			for (String user: users){
				try{
					String requestUrl = url + "/ModifyAceServlet?principalId=" + user +  "&resourcePath=" + absPath + privileges.toString() +"&order=" + order;
					logger.debug(requestUrl);
					getMethod =  new GetMethod(requestUrl);
					httpClient.executeMethod(getMethod);
					logger.debug("Response " + getMethod.getResponseBodyAsString());

					if(getMethod != null)
						getMethod.releaseConnection();

				}catch (Exception e) {
					logger.error("Error modifing ACLs: " + e);
					throw new InternalErrorException(e);
				}
			}

			XStream xstream = new XStream();
			Boolean modified = true;

			try{
				modified = (Boolean) xstream.fromXML(getMethod.getResponseBodyAsString());
			}catch (Exception e) {
				logger.error("Error in Modify ace", e);
			}
			//
			//			if (modified)
			//				logger.debug(absPath + " ACL modified");
			//			else
			//				System.out.println(absPath + " ACL has not been modified");

		} catch (Exception e) {
			logger.error("Error in Add or Modify Permissions in AccessManager", e);
			throw new InternalErrorException(e);
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}
	}

	@Override
	public Map<String, List<String>> getEACL(String absPath) throws InternalErrorException {

		Session session = JCRRepository.getSession();

		List<AccessControlEntry> allEntries = null;
		try {
			allEntries = new ArrayList<AccessControlEntry>();	

			AccessControlManager accessControlManager = session.getAccessControlManager();
			AccessControlPolicy[] policies = accessControlManager.getEffectivePolicies(absPath);
			for (AccessControlPolicy accessControlPolicy : policies) {
				if (accessControlPolicy instanceof AccessControlList) {
					AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
					for (AccessControlEntry accessControlEntry : accessControlEntries) {
						allEntries.add(accessControlEntry);
					}
				}
			}
		} catch (RepositoryException e) {
			logger.error("Error getting Effective ACL for node: " + absPath,e);
			throw new InternalErrorException(e);
		}

		//		System.out.println("get Effetctive ACL for path " + absPath);

		Map<String, List<String>> map = getMap(allEntries);

		//print
		logger.debug("ACL map: " + map.toString());

		return map;
	}


	private Map<String, List<String>> getMap(List<AccessControlEntry> allEntries) {
		Map<String, List<String>> map = new HashMap<String, List<String>>();

		for (AccessControlEntry entry: allEntries){
			List<String> privilegesList = null;
			//			System.out.println("- " + entry.getPrincipal().getName());

			String key = entry.getPrincipal().getName();
//			System.out.println(key);
			if (!key.equals("everyone")){
				try{			
					privilegesList = map.get(key);
					//				System.out.println("privilegesList " + privilegesList.size() );
				}catch (Exception e) {
					//				System.out.println("key: "+ key + ", does not exist yet");
				}

				Privilege[] privileges = entry.getPrivileges();
				for (int i=0; i< privileges.length; i++){
					//				System.out.println("* " + privileges[i].getName());
					if (privilegesList==null)
						privilegesList = new ArrayList<String>();
					privilegesList.add(privileges[i].getName());

				}
				map.put(entry.getPrincipal().getName(), privilegesList);	
			}
		}    			
		return map;
	}


	@Override
	public void setReadOnlyACL(List<String> users, String absPath)
			throws InternalErrorException {
		List<String> privileges = new ArrayList<String>();
		privileges.add("jcr:read=granted");
		try{
			modifyAce(users, absPath, privileges, null);
		}catch (Exception e) {
			logger.error("Error setting Read-only Ace", e);
			throw new InternalErrorException(e);
		}
	}


	//	/**
	//	 * If a user does not exist, create it now
	//	 * @param users
	//	 * @throws InternalErrorException
	//	 */
	//	private void checkUserList(List<String> users) throws InternalErrorException {
	//		JCRUserManager um = new JCRUserManager();
	//		for (String user: users){
	//			if (um.createUser(user))
	//				logger.trace("user " + user  + " has been created");
	//		}
	//	}



	@Override
	public void setWriteOwnerACL(List<String> users, String absPath)
			throws InternalErrorException {
		logger.debug("setAuthorAce - users: " + users.toString() + " - absPath: " + absPath);
		try {
			//			checkUserList(users);
			List<String> privileges = new ArrayList<String>();
			privileges.add("jcr:write=granted");
			try{
				modifyAce(users, absPath, privileges, null);
			}catch (Exception e) {
				e.printStackTrace();
				throw new InternalErrorException(e);
			}
			logger.debug("Ace modified");
		}catch (Exception e) {
			throw new InternalErrorException(e);
		} 

	}

	@Override
	public void setWriteAllACL(List<String> users, String absPath)
			throws InternalErrorException {
		List<String> privileges = new ArrayList<String>();
		privileges.add("hl:writeAll=granted");
		try{
			//			checkUserList(users);
			modifyAce(users, absPath, privileges, null);
		}catch (Exception e) {
			throw new InternalErrorException(e);
		}


	}

	@Override
	public void setAdminACL(List<String> users, String absPath)
			throws InternalErrorException {
		List<String> privileges = new ArrayList<String>();
		privileges.add("jcr:all=granted");
		try{
			//			checkUserList(users);
			modifyAce(users, absPath, privileges, null);
		}catch (Exception e) {
			throw new InternalErrorException(e);
		}

	}

 @Override
	public void deleteAces(String resourcePath, List<String> users) throws InternalErrorException {

		GetMethod getMethod = null;
		//		checkUserList(users);
		try {

			HttpClient httpClient = new HttpClient();      		

			StringBuilder applyTo= new StringBuilder();
			for (String user: users){	
				applyTo.append("&applyTo=" + user);
			}

			try{
				String requestUrl = url + "/DeleteAcesServlet?absPath=" + resourcePath +  applyTo;
				logger.debug(requestUrl);
				getMethod =  new GetMethod(requestUrl);
				httpClient.executeMethod(getMethod);
				logger.debug("Response " + getMethod.getResponseBodyAsString());

				if(getMethod != null)
					getMethod.releaseConnection();

			}catch (Exception e) {
				// TODO: handle exception
			}

			XStream xstream = new XStream();
			Boolean modified = true;

			try{
				modified = (Boolean) xstream.fromXML(getMethod.getResponseBodyAsString());
			}catch (Exception e) {
				logger.error("Error in Modify ace", e);
			}

			//			if (modified)
			//				System.out.println(resourcePath + " ACL deleted");
			//			else
			//				System.out.println(resourcePath + " ACL has not been deleted");

		} catch (Exception e) {
			logger.error("Error deleting Permissions in AccessManager", e);
			throw new InternalErrorException(e);
		} finally {
			if(getMethod != null)
				getMethod.releaseConnection();
		}
	}







}
