/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryType;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;

public class JCRAccountingEntryUpdate
extends JCRAccountingEntry
implements AccountingEntryUpdate {
    private static String ITEM_NAME = "hl:itemName";
    protected String itemName;

    public JCRAccountingEntryUpdate(Node node) throws RepositoryException {
        super(node);
        this.itemName = node.getProperty(ITEM_NAME).getString();
    }

    public JCRAccountingEntryUpdate(String user, Calendar date, String nodeName) {
        super(user, date);
        this.itemName = nodeName;
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.UPDATE;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s]]", parentValue, this.getEntryType());
    }

    @Override
    public void save(Node entryNode) throws RepositoryException {
        super.save(entryNode);
        entryNode.setProperty(ITEM_NAME, this.itemName);
    }

    public String getItemName() {
        return this.itemName;
    }
}

