package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;

import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.util.WorkspaceItemUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRPDFFile extends JCRFile {
	
	private static final String NUMBER_OF_PAGES = "hl:numberOfPages";
	private static final String VERSION = "hl:version";
	private static final String AUTHOR = "hl:author";
	private static final String TITLE = "hl:title";
	private static final String PRODUCER = "hl:producer";
	

	
	public JCRPDFFile(JCRWorkspace workspace, Node node) throws RepositoryException   {
		super(workspace, node);
	}
	
	
	public JCRPDFFile(JCRWorkspace workspace, Node node, InputStream data) throws RepositoryException,
	IOException, RemoteBackendException{
		super(workspace, node,new BufferedInputStream(data));
		
		setProperties(node);
	}
	
	public JCRPDFFile(JCRWorkspace workspace, Node node, String mimeType,InputStream data) throws RepositoryException,
	IOException, RemoteBackendException{
		super(workspace, node,new BufferedInputStream(data));
		
		setProperties(node);
	}
	
	private void setProperties(Node node) throws ValueFormatException, PathNotFoundException, RepositoryException, IOException {
		
//		String remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
//		InputStream dataPdf = GCUBEStorage.getRemoteFile(remotePath, portalLogin);
		
		InputStream dataPdf = new FileInputStream(tmpFile);  
		
		Map<String,String> infoPDF = WorkspaceItemUtil.getPDFInfo(dataPdf);
		int numberOfPages = Integer.parseInt(infoPDF.get(WorkspaceItemUtil.NUMBER_OF_PAGES));
		String version = infoPDF.get(WorkspaceItemUtil.VERSION);
		String author = infoPDF.get(WorkspaceItemUtil.AUTHOR);
		String title = infoPDF.get(WorkspaceItemUtil.TITLE);
		String producer = infoPDF.get(WorkspaceItemUtil.PRODUCER);
		
		node.setProperty(NUMBER_OF_PAGES, numberOfPages);
		node.setProperty(VERSION, version);
		node.setProperty(AUTHOR, author);
		node.setProperty(TITLE, title);
		node.setProperty(PRODUCER, producer);

		dataPdf.close();
//		tmpFile.delete();
	}

	public FolderItemType getFolderItemType() {
		return FolderItemType.EXTERNAL_PDF_FILE;	
	}

	public int getNumberOfPages() {	
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return (int) node.getProperty(NUMBER_OF_PAGES).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
	}

	public String getVersion() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return node.getProperty(VERSION).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
	}

	public String getAuthor() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return node.getProperty(AUTHOR).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
		
	}

	public String getTitle() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return node.getProperty(TITLE).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
		
	}

	public String getProducer() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return  node.getProperty(PRODUCER).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
	}
	
	@Override
	public String getPublicLink() throws InternalErrorException {
		return super.getPublicLink();
	}


	@Override
	public void updateInfo() throws InternalErrorException {
		super.updateInfo();
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			setProperties(node);
			session.save();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}
				
	}

}
