/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.repository;

import java.security.Key;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRRepository {
    public static final String HL_NAMESPACE = "hl:";
    public static final String JCR_NAMESPACE = "jcr:";
    public static final String REP_NAMESPACE = "rep:";
    public static final String PATH_SEPARATOR = "/";
    public static final String ROOT_WEBDAV = "/repository/default/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    private static final String DOWNLOADS = "Downloads";
    private static final String SMART_FOLDER = "Folders";
    private static final String GCUBE_FOLDER = "GCube";
    private static final String IN_BOX_FOLDER = "InBox";
    private static final String OUT_BOX_FOLDER = "OutBox";
    private static final String HIDDEN_FOLDER = "HiddenFolder";
    private static final String NT_FOLDER = "nt:folder";
    private static final String NT_HOME = "nthl:home";
    public static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    private static final String NT_ROOT_ITEM_SENT = "nthl:rootItemSentRequest";
    private static final String NT_ROOT_FOLDER_BULK_CREATOR = "nthl:rootFolderBulkCreator";
    private static final String SCOPES = "hl:scopes";
    private static final String nameResource = "HomeLibraryRepository";
    private static Repository repository;
    private static String gcubeRootId;
    private static String sharedRootId;
    private String userHomeId;
    private String smartFoldersId;
    private String downloadsId;
    private String inBoxId;
    private String outBoxId;
    private String hiddenFolderId;
    private static String user;
    private static String pass;
    public static String url;
    private static String webdavUrl;
    private static Logger logger;

    private static synchronized void initializeRepository() throws InternalErrorException {
        if (repository != null) {
            return;
        }
        String callerScope = ScopeProvider.instance.get();
        try {
            if (callerScope == null) {
                throw new IllegalArgumentException("scope is null");
            }
            String rootScope = Utils.getRootScope(callerScope);
            logger.debug("scope for repository creation is " + rootScope + " caller scope is " + callerScope);
            ScopeProvider.instance.set(rootScope);
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Category/text() eq 'Database' and $resource/Profile/Name eq 'HomeLibraryRepository' ");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List resources = client.submit((Query)query);
            if (resources.size() != 0) {
                try {
                    ServiceEndpoint resource = (ServiceEndpoint)resources.get(0);
                    for (ServiceEndpoint.AccessPoint ap : resource.profile().accessPoints()) {
                        if (ap.name().equals("JCR")) {
                            url = ap.address();
                            user = ap.username();
                            pass = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
                            continue;
                        }
                        if (!ap.name().equals("WebDav")) continue;
                        webdavUrl = ap.address();
                    }
                }
                catch (Throwable e) {
                    logger.error("error decrypting resource", e);
                }
            }
            if (user == null || pass == null) {
                throw new InternalErrorException("cannot discover password and username in scope " + callerScope);
            }
            repository = new URLRemoteRepository(url + "/rmi");
            logger.debug("user is " + user + " password is null?" + (pass == null) + " and repository is null?" + (repository == null));
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (callerScope != null) {
                ScopeProvider.instance.set(callerScope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHomeNames() throws RepositoryException {
        ArrayList<String> homes = new ArrayList<String>();
        Session session = null;
        try {
            try {
                session = JCRRepository.getSession();
            }
            catch (InternalErrorException e) {
                logger.error("error gettin session", (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
            Node home = (Node)session.getItem("/Home");
            NodeIterator it = home.getNodes();
            while (it.hasNext()) {
                Node node = it.nextNode();
                if (!node.getPrimaryNodeType().getName().equals(NT_HOME)) continue;
                homes.add(node.getName());
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return homes;
    }

    public static Session getSession(String user) throws InternalErrorException {
        try {
            logger.debug("session of " + user);
            Session session = repository.login((Credentials)new SimpleCredentials(user, JCRUserManager.getSecurePassword(user).toCharArray()));
            return session;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public static Session getSession() throws InternalErrorException {
        JCRRepository.initializeRepository();
        Repository repository = JCRRepository.repository;
        synchronized (repository) {
            try {
                Session session = JCRRepository.repository.login((Credentials)new SimpleCredentials(user, pass.toCharArray()));
                return session;
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    public static synchronized void initialize() throws InternalErrorException {
        logger.debug("Initialize repository");
        Session session = JCRRepository.getSession();
        try {
            Node root = session.getRootNode();
            String[] list = new String[]{HOME_FOLDER, GCUBE_FOLDER, SHARED_FOLDER};
            NodeIterator nodes = root.getNodes(list);
            LinkedList<String> listNodes = new LinkedList<String>();
            while (nodes.hasNext()) {
                Node myNode = nodes.nextNode();
                String nodeName = myNode.getName();
                listNodes.add(nodeName);
                switch (nodeName) {
                    case "Home": {
                        break;
                    }
                    case "GCube": {
                        gcubeRootId = myNode.getIdentifier();
                        break;
                    }
                    case "Share": {
                        sharedRootId = myNode.getIdentifier();
                        break;
                    }
                }
            }
            LinkedList<String> myList = new LinkedList<String>(Arrays.asList(list));
            myList.removeAll(listNodes);
            if (myList.size() != 0) {
                JCRRepository.createMissingRootFolders(root, myList);
                session.save();
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private static void createMissingRootFolders(Node root, List<String> missingFolders) throws InternalErrorException {
        logger.trace("Creating Root folders: " + missingFolders.toString());
        try {
            Iterator<String> i$ = missingFolders.iterator();
            while (i$.hasNext()) {
                String folder;
                switch (folder = i$.next()) {
                    case "Home": {
                        Node homeFolder = root.addNode(HOME_FOLDER, NT_FOLDER);
                        break;
                    }
                    case "GCube": {
                        Node gCubeFolder = root.addNode(GCUBE_FOLDER, NT_FOLDER);
                        gcubeRootId = gCubeFolder.getIdentifier();
                        break;
                    }
                    case "Share": {
                        Node sharedFolder = root.addNode(SHARED_FOLDER, NT_FOLDER);
                        sharedRootId = sharedFolder.getIdentifier();
                        break;
                    }
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Repository not instantiated", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public JCRRepository(User user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node root = session.getRootNode();
            Node home = root.getNode(HOME_FOLDER);
            Node userHome = !JCRRepository.exist(home, user.getPortalLogin()) ? home.addNode(user.getPortalLogin(), NT_HOME) : home.getNode(user.getPortalLogin());
            this.userHomeId = userHome.getIdentifier();
            JCRUserManager um = new JCRUserManager();
            um.createUser(user.getPortalLogin());
            String[] list = new String[]{SMART_FOLDER, IN_BOX_FOLDER, OUT_BOX_FOLDER, HIDDEN_FOLDER, DOWNLOADS};
            NodeIterator node = userHome.getNodes(list);
            ArrayList<String> listNodes = new ArrayList<String>();
            while (node.hasNext()) {
                Node myNode = node.nextNode();
                String nodeName = myNode.getName();
                listNodes.add(nodeName);
                switch (nodeName) {
                    case "Folders": {
                        this.smartFoldersId = myNode.getIdentifier();
                        break;
                    }
                    case "InBox": {
                        this.inBoxId = myNode.getIdentifier();
                        break;
                    }
                    case "OutBox": {
                        this.outBoxId = myNode.getIdentifier();
                        break;
                    }
                    case "HiddenFolder": {
                        this.hiddenFolderId = myNode.getIdentifier();
                        break;
                    }
                    case "Downloads": {
                        this.downloadsId = myNode.getIdentifier();
                        break;
                    }
                }
            }
            LinkedList<String> myList = new LinkedList<String>(Arrays.asList(list));
            myList.removeAll(listNodes);
            if (myList.size() != 0) {
                this.createMissingFolders(userHome, myList);
                userHome.getSession().save();
            }
        }
        catch (RepositoryException e) {
            logger.error("Repository not instantiated", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private void createMissingFolders(Node userHome, List<String> missingFolders) throws InternalErrorException {
        logger.trace("Creating folders: " + missingFolders.toString());
        try {
            Iterator<String> i$ = missingFolders.iterator();
            while (i$.hasNext()) {
                String folder;
                switch (folder = i$.next()) {
                    case "Folders": {
                        Node smartFolders = userHome.addNode(SMART_FOLDER, NT_FOLDER);
                        this.smartFoldersId = smartFolders.getIdentifier();
                        break;
                    }
                    case "InBox": {
                        Node inBoxNode = userHome.addNode(IN_BOX_FOLDER, NT_ROOT_ITEM_SENT);
                        this.inBoxId = inBoxNode.getIdentifier();
                        break;
                    }
                    case "OutBox": {
                        Node outBoxNode = userHome.addNode(OUT_BOX_FOLDER, NT_ROOT_ITEM_SENT);
                        this.outBoxId = outBoxNode.getIdentifier();
                        break;
                    }
                    case "HiddenFolder": {
                        Node hiddenFolder = userHome.addNode(HIDDEN_FOLDER, NT_FOLDER);
                        this.hiddenFolderId = hiddenFolder.getIdentifier();
                        break;
                    }
                    case "Downloads": {
                        Node downloads = userHome.addNode(DOWNLOADS, NT_ROOT_FOLDER_BULK_CREATOR);
                        this.downloadsId = downloads.getIdentifier();
                        break;
                    }
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Repository not instantiated", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public static void removeUser(User user) throws Exception {
        Session session = JCRRepository.getSession();
        Node node = session.getRootNode().getNode(HOME_FOLDER).getNode(user.getPortalLogin());
        node.remove();
        session.save();
    }

    public static void setACL(final String portalLogin, String userHome) throws InternalErrorException {
        Session session = null;
        try {
            URLRemoteRepository RMIrepository = new URLRemoteRepository(url + "/rmi");
            session = RMIrepository.login((Credentials)new SimpleCredentials(user, pass.toCharArray()));
            AccessControlManager accessControlManager = session.getAccessControlManager();
            AccessControlPolicyIterator acpIterator = accessControlManager.getApplicablePolicies(userHome);
            if (acpIterator.hasNext()) {
                logger.debug(" ------------ ACL Present ");
                AccessControlPolicy policy = acpIterator.nextAccessControlPolicy();
                AccessControlList list = (AccessControlList)policy;
                list.addAccessControlEntry(new Principal(){

                    @Override
                    public String getName() {
                        return portalLogin;
                    }
                }, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")});
                accessControlManager.setPolicy(userHome, (AccessControlPolicy)list);
            }
            session.save();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void setScope(Session session, String scope) throws RepositoryException {
        Property scopes;
        Node userHome = this.getUserHome(session);
        try {
            scopes = userHome.getProperty(SCOPES);
        }
        catch (PathNotFoundException e) {
            String[] values = new String[]{scope};
            userHome.setProperty(SCOPES, values);
            return;
        }
        for (Value value : scopes.getValues()) {
            if (!value.getString().equals(scope)) continue;
            return;
        }
        String[] newScopes = new String[scopes.getValues().length + 1];
        newScopes[0] = scope;
        for (int i = 1; i < newScopes.length; ++i) {
            newScopes[i] = scopes.getValues()[i - 1].getString();
        }
        userHome.setProperty(SCOPES, newScopes);
    }

    private static boolean exist(Node parent, String childName) throws RepositoryException {
        try {
            parent.getNode(childName);
        }
        catch (PathNotFoundException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listScopes() throws RepositoryException, InternalErrorException {
        LinkedList<String> list = new LinkedList<String>();
        Session session = JCRRepository.getSession();
        try {
            Node userHome = session.getNodeByIdentifier(this.userHomeId);
            Property scopes = userHome.getProperty(SCOPES);
            for (Value value : scopes.getValues()) {
                list.add(value.getString());
            }
            LinkedList<String> linkedList = list;
            return linkedList;
        }
        catch (PathNotFoundException e) {
            LinkedList<String> linkedList = new LinkedList<String>();
            return linkedList;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public static Node getGCubeRoot(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(gcubeRootId);
    }

    public static Node getSharedRoot(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(sharedRootId);
    }

    public Node getUserHome(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.userHomeId);
    }

    public Node getRootSmartFolders(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.smartFoldersId);
    }

    public Node getOwnInBoxFolder(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.inBoxId);
    }

    public Node getRootFolderBulkCreators(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.downloadsId);
    }

    public Node getOutBoxFolder(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.outBoxId);
    }

    public Node getHiddenFolder(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.hiddenFolderId);
    }

    public Node getInBoxFolder(Session session, String user) throws RepositoryException, InternalErrorException {
        return session.getRootNode().getNode("Home/" + user + PATH_SEPARATOR + IN_BOX_FOLDER);
    }

    public String getUserHomeUrl(String portalLogin) {
        return url + ROOT_WEBDAV + HOME_FOLDER + PATH_SEPARATOR + portalLogin;
    }

    public String getWebDavUrl(String portalLogin) {
        return webdavUrl + PATH_SEPARATOR + portalLogin;
    }

    static {
        logger = LoggerFactory.getLogger(JCRRepository.class);
    }
}

