/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSmartFolder;
import org.gcube.common.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.common.homelibrary.home.workspace.events.AbstractWorkspaceEventSource;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongParentTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreatorManager;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.TabularDataLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Annotation;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.link.DocumentLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.link.ImageDocumentLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.link.PDFDocumentLink;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.home.workspace.search.SearchFolderItem;
import org.gcube.common.homelibrary.home.workspace.search.SearchItem;
import org.gcube.common.homelibrary.home.workspace.search.SearchItemByOperator;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashFolder;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.home.JCRHome;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.sharing.JCRWorkspaceMessageManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRFolderBulkCreatorManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSharedFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSmartFolder;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRAquaMapsItem;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalImage;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalPDFFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRExternalUrl;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRGCubeItem;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRPDFFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRQuery;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRReport;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRReportTemplate;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRTabularDataLink;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRTimeSeries;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkflowReport;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkflowTemplate;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRAnnotation;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRDocument;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRExternalResourceLink;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRImageDocument;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRMetadata;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRPDFDocument;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRUrlDocument;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.link.JCRDocumentLink;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.link.JCRImageDocumentLink;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.link.JCRPDFDocumentLink;
import org.gcube.common.homelibrary.jcr.workspace.search.JCRSearchFolder;
import org.gcube.common.homelibrary.jcr.workspace.search.JCRSearchFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashFolder;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashItem;
import org.gcube.common.homelibrary.util.Util;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspace
extends AbstractWorkspaceEventSource
implements Workspace {
    public static final String HOME_FOLDER = "Home";
    private static final String WORKSPACE_ROOT_FOLDER = "Workspace";
    private static final String APPLICATION_FOLDER = ".applications";
    private static final String TRASH = "Trash";
    private static final String SPECIAL_FOLDER = "MySpecialFolders";
    public static final String NT_WORKSPACE_TRASH = "nthl:trashFolder";
    public static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    public static final String NT_WORKSPACE_SHARED_FOLDER = "nthl:workspaceSharedItem";
    public static final String NT_WORKSPACE_FOLDER_ITEM = "nthl:workspaceLeafItem";
    public static final String NT_WORKSPACE_FILE = "nthl:externalFile";
    public static final String NT_WORKSPACE_IMAGE = "nthl:externalImage";
    public static final String NT_WORKSPACE_PDF_FILE = "nthl:externalPdf";
    public static final String NT_WORKSPACE_URL = "nthl:externalUrl";
    public static final String NT_WORKSPACE_REPORT = "nthl:report";
    public static final String NT_WORKSPACE_REPORT_TEMPLATE = "nthl:reportTemplate";
    public static final String NT_WORKSPACE_WORKFLOW_REPORT = "nthl:workflowReport";
    public static final String NT_WORKSPACE_WORKFLOW_TEMPLATE = "nthl:workflowTemplate";
    public static final String NT_ANNOTATION_ITEM = "nthl:gCubeAnnotation";
    public static final String NT_ANNOTATION_LINK_ITEM = "nthl:gCubeAnnotationLink";
    public static final String NT_DOCUMENT_ITEM = "nthl:gCubeDocument";
    public static final String NT_DOCUMENT_LINK_ITEM = "nthl:gCubeDocumentLink";
    public static final String NT_IMAGE_DOCUMENT_ITEM = "nthl:gCubeImageDocument";
    public static final String NT_IMAGE_DOCUMENT_LINK_ITEM = "nthl:gCubeImageDocumentLink";
    public static final String NT_PDF_DOCUMENT_ITEM = "nthl:gCubePDFDocument";
    public static final String NT_PDF_DOCUMENT_LINK_ITEM = "nthl:gCubePDFDocumentLink";
    public static final String NT_URL_DOCUMENT_ITEM = "nthl:gCubeURLDocument";
    public static final String NT_METADATA_ITEM = "nthl:gCubeMetadata";
    public static final String NT_METADATA_LINK_ITEM = "nthl:gCubeMetadataLink";
    public static final String NT_AQUAMAPS_ITEM = "nthl:aquamapsItem";
    public static final String NT_GCUBE_ITEM = "nthl:gCubeItem";
    public static final String NT_TIMESERIES_ITEM = "nthl:timeSeriesItem";
    public static final String NT_QUERY = "nthl:query";
    public static final String NT_EXTERNAL_RESOURCE_LINK_ITEM = "nthl:externalResourceLink";
    public static final String NT_TABULAR_DATA_LINK = "nthl:tabularDataLink";
    public static final String NT_TRASH_ITEM = "nthl:trashItem";
    private static final String NT_FILE = "nt:file";
    private static final String CONTENT = "jcr:content";
    private static final String LAST_MODIFIED = "jcr:lastModified";
    private static final String LAST_MODIFIED_BY = "jcr:lastModifiedBy";
    private static final String LAST_ACTION = "hl:lastAction";
    public static final String USERS = "hl:users";
    public static final String MEMBERS = "hl:members";
    private final Home home;
    public final JCRRepository repository;
    private final JCRFolderBulkCreatorManager folderBulkCreatorsManager;
    private JCRWorkspaceFolder root;
    public String rootId;
    private JCRWorkspaceFolder applicationFolder;
    public JCRWorkspaceFolder trashFolder;
    public JCRWorkspaceFolder mySpecialFolders;
    public String applicationFolderId;
    public String trashId;
    public String mySpecialFoldersId;
    private JCRWorkspaceMessageManager sendRequestManager;
    private String userHomePath;
    private Logger logger;

    public JCRWorkspace(Home home, JCRRepository repository) throws InternalErrorException {
        String pathRoot;
        this.home = home;
        this.repository = repository;
        this.folderBulkCreatorsManager = new JCRFolderBulkCreatorManager(this);
        this.logger = LoggerFactory.getLogger(JCRWorkspace.class);
        Session session = JCRRepository.getSession();
        try {
            Node userHome = repository.getUserHome(session);
            this.userHomePath = userHome.getPath();
            Node wsNode = null;
            try {
                wsNode = userHome.addNode(WORKSPACE_ROOT_FOLDER, NT_WORKSPACE_FOLDER);
                this.root = new JCRWorkspaceFolder(this, wsNode, WORKSPACE_ROOT_FOLDER, "The root");
                this.root.save(wsNode);
            }
            catch (ItemExistsException e) {
                wsNode = userHome.getNode(WORKSPACE_ROOT_FOLDER);
                this.root = new JCRWorkspaceFolder(this, wsNode);
            }
            this.rootId = wsNode.getIdentifier();
            pathRoot = wsNode.getPath();
            String[] list = new String[]{APPLICATION_FOLDER, TRASH, SPECIAL_FOLDER};
            LinkedList<String> myList = new LinkedList<String>(Arrays.asList(list));
            NodeIterator node = wsNode.getNodes(list);
            ArrayList<String> listWSNodes = new ArrayList<String>();
            while (node.hasNext()) {
                Node myNode = node.nextNode();
                String nodeName = myNode.getName();
                listWSNodes.add(nodeName);
                switch (nodeName) {
                    case ".applications": {
                        this.applicationFolderId = myNode.getIdentifier();
                        this.applicationFolder = new JCRWorkspaceFolder(this, wsNode.getNode(APPLICATION_FOLDER));
                        break;
                    }
                    case "Trash": {
                        this.trashId = myNode.getIdentifier();
                        this.trashFolder = new JCRWorkspaceFolder(this, wsNode.getNode(TRASH));
                        break;
                    }
                    case "MySpecialFolders": {
                        this.mySpecialFoldersId = myNode.getIdentifier();
                        this.mySpecialFolders = new JCRWorkspaceFolder(this, wsNode.getNode(SPECIAL_FOLDER));
                        break;
                    }
                }
            }
            myList.removeAll(listWSNodes);
            if (myList.size() != 0) {
                this.createMissingWSFolders(wsNode, myList);
                userHome.getSession().save();
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Root WorkspaceFolder failed creation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        JCRRepository.setACL(home.getOwner().getPortalLogin(), pathRoot);
    }

    private void createMissingWSFolders(Node userHome, List<String> missingFolders) throws InternalErrorException {
        this.logger.trace("Creating folders: " + missingFolders.toString());
        try {
            Iterator<String> i$ = missingFolders.iterator();
            while (i$.hasNext()) {
                String folder;
                switch (folder = i$.next()) {
                    case ".applications": {
                        Node appFolders = userHome.addNode(APPLICATION_FOLDER, NT_WORKSPACE_FOLDER);
                        this.applicationFolderId = appFolders.getIdentifier();
                        this.applicationFolder = new JCRWorkspaceFolder(this, appFolders, APPLICATION_FOLDER, "Applications folder");
                        break;
                    }
                    case "Trash": {
                        Node trashNode = userHome.addNode(TRASH, NT_WORKSPACE_FOLDER);
                        this.trashId = trashNode.getIdentifier();
                        this.trashFolder = new JCRWorkspaceFolder(this, trashNode, TRASH, "Trash folder");
                        break;
                    }
                    case "MySpecialFolders": {
                        Node specialNode = userHome.addNode(SPECIAL_FOLDER, NT_WORKSPACE_FOLDER);
                        this.mySpecialFoldersId = specialNode.getIdentifier();
                        this.mySpecialFolders = new JCRWorkspaceFolder(this, specialNode, SPECIAL_FOLDER, "My Special Folders");
                        break;
                    }
                }
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Repository not instantiated", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public JCRWorkspace(JCRHome home) {
        this.home = home;
        this.repository = null;
        this.folderBulkCreatorsManager = null;
    }

    private Node addChildNode(Session session, String parentId, String nodeName, String nodeType) throws ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, WrongDestinationException, InsufficientPrivilegesException {
        Node parent;
        Validate.notNull((Object)parentId, (String)"Destination folder must be not null");
        Validate.notNull((Object)nodeName, (String)"Name must be not null");
        if (!this.isValidName(nodeName)) {
            this.logger.error("The name  " + nodeName + "contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        try {
            parent = session.getNodeByIdentifier(parentId);
            JCRWorkspaceItem item = this.getWorkspaceItem(parent);
            if (item.isShared() && !JCRPrivilegesInfo.canAddChildren(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), parent.getPath())) {
                throw new InsufficientPrivilegesException("Insufficient Privileges to add the node");
            }
            if (!(parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) || parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER) || parent.getPrimaryNodeType().getName().equals("nt:folder"))) {
                throw new WrongDestinationException("Not is a folder");
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Destination folder not found");
            throw new WorkspaceFolderNotFoundException(e.getMessage());
        }
        try {
            String name = Text.escapeIllegalJcrChars((String)nodeName);
            Node node = parent.addNode(name, nodeType);
            return node;
        }
        catch (ItemExistsException e) {
            this.logger.error("Item already exist");
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            this.logger.error("Error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public String getPathSeparator() {
        return "/";
    }

    public Home getHome() {
        return this.home;
    }

    public JCRRepository getRepository() {
        return this.repository;
    }

    public User getOwner() {
        return this.home.getOwner();
    }

    public WorkspaceFolder getRoot() {
        return this.root;
    }

    public WorkspaceFolder createFolder(String name, String description, String destinationFolderId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create workspace folder");
        Session session = JCRRepository.getSession();
        try {
            Node parent = session.getNodeByIdentifier(destinationFolderId);
            JCRWorkspaceItem destinationFolder = (JCRWorkspaceItem)this.getItem(destinationFolderId);
            if (destinationFolder.isShared() && !JCRPrivilegesInfo.canAddChildren(destinationFolder.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), parent.getPath())) {
                throw new InsufficientPrivilegesException("Insufficient Privileges to add the folder");
            }
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FOLDER);
            JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, node, name, description);
            folder.save(node);
            session.save();
            try {
                this.logger.info(folder.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), folder.getType(), folder.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)folder).getFolderItemType() : null, folder.getName(), folder.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)folder).getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.error("Error setting add accounting entry for " + folder.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(folder);
            JCRWorkspaceFolder jCRWorkspaceFolder = folder;
            return jCRWorkspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalImage createExternalImage(String name, String description, String mimeType, InputStream imageData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external image");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_IMAGE);
            JCRExternalImage item = new JCRExternalImage(this, node, name, description, mimeType, imageData);
            item.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(item);
            JCRExternalImage jCRExternalImage = item;
            return jCRExternalImage;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalFile createExternalFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external file");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FILE);
            JCRExternalFile item = new JCRExternalFile(this, node, name, description, mimeType, fileData);
            item.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(item);
            JCRExternalFile jCRExternalFile = item;
            return jCRExternalFile;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalPDFFile createExternalPDFFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external pdf file");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_PDF_FILE);
            JCRExternalPDFFile item = new JCRExternalPDFFile(this, node, name, description, mimeType, fileData);
            item.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(item);
            JCRExternalPDFFile jCRExternalPDFFile = item;
            return jCRExternalPDFFile;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalUrl createExternalUrl(String name, String description, String url, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create external url");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_URL);
            JCRExternalUrl item = new JCRExternalUrl(this, node, name, description, url);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRExternalUrl jCRExternalUrl = item;
            return jCRExternalUrl;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalUrl createExternalUrl(String name, String description, InputStream url, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        String urlString;
        try {
            urlString = Util.readStreamAsString((InputStream)url);
        }
        catch (IOException e) {
            throw new InternalErrorException("Error converting url from input stream to string.");
        }
        return this.createExternalUrl(name, description, urlString, destinationFolderId);
    }

    public ReportTemplate createReportTemplate(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, int numberOfSections, String status, InputStream templateData, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Created report template");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationfolderId, name, NT_WORKSPACE_REPORT_TEMPLATE);
            JCRReportTemplate reportTemplate = new JCRReportTemplate(this, node, name, description, created, lastEdit, author, lastEditBy, numberOfSections, status, templateData);
            reportTemplate.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(reportTemplate.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), reportTemplate.getType(), reportTemplate.getType() == WorkspaceItemType.FOLDER_ITEM ? reportTemplate.getFolderItemType() : null, reportTemplate.getName(), reportTemplate.getType() == WorkspaceItemType.FOLDER_ITEM ? reportTemplate.getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + reportTemplate.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(reportTemplate);
            JCRReportTemplate jCRReportTemplate = reportTemplate;
            return jCRReportTemplate;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Report createReport(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, String templateName, int numberOfSections, String status, InputStream reportData, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create report");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationfolderId, name, NT_WORKSPACE_REPORT);
            JCRReport item = new JCRReport(this, node, name, description, created, lastEdit, author, lastEditBy, templateName, numberOfSections, status, reportData);
            item.save(node);
            session.save();
            try {
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(node.getParent());
                this.logger.info(item.getPath() + " has been added to parent folder " + node.getPath());
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? item.getMimeType() : null));
                session.save();
            }
            catch (Exception e) {
                this.logger.info("Error setting add accounting entry for " + item.getPath() + " to parent folder " + node.getPath());
            }
            this.fireItemCreatedEvent(item);
            JCRReport jCRReport = item;
            return jCRReport;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public org.gcube.common.homelibrary.home.workspace.folder.items.Query createQuery(String name, String description, String query, QueryType queryType, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create query");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_QUERY);
            JCRQuery item = new JCRQuery(this, node, name, description, query, queryType);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRQuery jCRQuery = item;
            return jCRQuery;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public org.gcube.common.homelibrary.home.workspace.folder.items.Query createQuery(String name, String description, InputStream query, QueryType queryType, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        try {
            return this.createQuery(name, description, Util.readStreamAsString((InputStream)query), queryType, destinationFolderId);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceFolder createAquaMapsItem(String name, String description, String mapName, String mapType, String author, int numberOfSpecies, String boundingBox, float psoThreshold, int numberOfGeneratedImages, InputStream metadata, Map<String, InputStream> images, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        JCRWorkspaceFolder folder;
        this.logger.trace("Create aquamaps item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FOLDER);
            folder = new JCRWorkspaceFolder(this, node, name, description);
            folder.save(node);
            String fileName = WorkspaceUtil.getUniqueName((String)"metadata.xml", (WorkspaceFolder)folder);
            Node nodeFile = this.addChildNode(session, node.getIdentifier(), fileName, NT_WORKSPACE_FILE);
            JCRExternalFile file = new JCRExternalFile(this, nodeFile, fileName, name + " metadata", "text/xml", metadata);
            file.save(nodeFile);
            this.fireItemCreatedEvent(file);
            for (Map.Entry<String, InputStream> entry : images.entrySet()) {
                String imageName = Text.escapeIllegalJcrChars((String)entry.getKey());
                Node imageNode = this.addChildNode(session, node.getIdentifier(), imageName, NT_WORKSPACE_IMAGE);
                JCRExternalImage image = new JCRExternalImage(this, imageNode, imageName, description, "", entry.getValue());
                image.save(imageNode);
                this.fireItemCreatedEvent(image);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return folder;
    }

    public Annotation createAnnotation(String name, String description, String oid, Map<String, String> data, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create annotation item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_ANNOTATION_ITEM);
            JCRAnnotation item = new JCRAnnotation(this, node, name, description, oid, data);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRAnnotation jCRAnnotation = item;
            return jCRAnnotation;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Metadata createMetadata(String name, String description, String oid, String schema, String language, String data, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create metadata item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_METADATA_ITEM);
            JCRMetadata item = new JCRMetadata(this, node, name, description, oid, schema, language, collectionName, data);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRMetadata jCRMetadata = item;
            return jCRMetadata;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Document createDocument(String name, String description, String oid, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_DOCUMENT_ITEM);
            JCRDocument item = new JCRDocument(this, node, name, description, oid, mimeType, documentData, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRDocument jCRDocument = item;
            return jCRDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ImageDocument createImageDocument(String name, String description, String oid, String mimeType, InputStream imageData, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create image document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_IMAGE_DOCUMENT_ITEM);
            JCRImageDocument item = new JCRImageDocument(this, node, name, description, oid, mimeType, imageData, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRImageDocument jCRImageDocument = item;
            return jCRImageDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public PDFDocument createPDFDocument(String name, String description, String oid, String mimeType, InputStream data, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create pdf document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_PDF_DOCUMENT_ITEM);
            JCRPDFDocument item = new JCRPDFDocument(this, node, name, description, oid, mimeType, data, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRPDFDocument jCRPDFDocument = item;
            return jCRPDFDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public UrlDocument createUrlDocument(String name, String description, String oid, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create url document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_URL_DOCUMENT_ITEM);
            JCRUrlDocument item = new JCRUrlDocument(this, node, name, description, oid, mimeType, documentData, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRUrlDocument jCRUrlDocument = item;
            return jCRUrlDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public DocumentLink createDocumentLink(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace("Create document link item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_DOCUMENT_LINK_ITEM);
            JCRDocumentLink item = new JCRDocumentLink(this, node, name, description, oid, mimeType, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRDocumentLink jCRDocumentLink = item;
            return jCRDocumentLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ImageDocumentLink createImageDocumentLink(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_IMAGE_DOCUMENT_LINK_ITEM);
            JCRImageDocumentLink item = new JCRImageDocumentLink(this, node, name, description, oid, mimeType, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRImageDocumentLink jCRImageDocumentLink = item;
            return jCRImageDocumentLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public PDFDocumentLink createPDFDocumentLink(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_PDF_DOCUMENT_LINK_ITEM);
            JCRPDFDocumentLink item = new JCRPDFDocumentLink(this, node, name, description, oid, mimeType, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRPDFDocumentLink jCRPDFDocumentLink = item;
            return jCRPDFDocumentLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public TimeSeries createTimeSeries(String name, String description, String timeseriesId, String title, String creator, String timeseriesDescription, String timeseriesCreationDate, String publisher, String sourceId, String sourceName, String rights, long dimension, List<String> headerLabels, InputStream compressedCSV, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace("Create TimeSeries item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_TIMESERIES_ITEM);
            JCRTimeSeries item = new JCRTimeSeries(this, node, name, description, timeseriesId, title, creator, timeseriesDescription, timeseriesCreationDate, publisher, sourceId, sourceName, rights, dimension, headerLabels, compressedCSV);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRTimeSeries jCRTimeSeries = item;
            return jCRTimeSeries;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkflowReport createWorkflowReport(String name, String description, String workflowId, String workflowStatus, String workflowData, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace("Create WorkflowReport item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_WORKFLOW_REPORT);
            JCRWorkflowReport item = new JCRWorkflowReport(this, node, name, description, workflowId, workflowStatus, workflowData);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRWorkflowReport jCRWorkflowReport = item;
            return jCRWorkflowReport;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkflowTemplate createWorkflowTemplate(String name, String description, String workflowId, String workflowStatus, String workflowData, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace("Create WorkflowTemplate item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_WORKFLOW_TEMPLATE);
            JCRWorkflowTemplate item = new JCRWorkflowTemplate(this, node, name, description, workflowId, workflowStatus, workflowData);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRWorkflowTemplate jCRWorkflowTemplate = item;
            return jCRWorkflowTemplate;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalResourceLink createExternalResourceLink(String name, String description, String mimeType, String resourceId, String pluginName, String destinationFolderId) throws WorkspaceFolderNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException {
        this.logger.trace("Create service resource link");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_EXTERNAL_RESOURCE_LINK_ITEM);
            JCRExternalResourceLink item = new JCRExternalResourceLink(this, node, name, mimeType, description, resourceId, pluginName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRExternalResourceLink jCRExternalResourceLink = item;
            return jCRExternalResourceLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void removeItem(String itemId) throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        block17: {
            Validate.notNull((Object)itemId, (String)"Item id must be not null");
            Session session = JCRRepository.getSession();
            Node node = null;
            try {
                node = session.getNodeByIdentifier(itemId);
                this.logger.trace("Remove node " + node.getPath());
                JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(session, itemId);
                if (item.isShared()) {
                    this.logger.debug("the item is shared: " + node.getPath());
                    if (!JCRPrivilegesInfo.canDelete(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), node.getPath(), false)) {
                        throw new InsufficientPrivilegesException("Insufficient Privileges to remove the node " + node.getPath());
                    }
                }
                JCRWorkspaceItem parent = (JCRWorkspaceItem)item.getParent();
                try {
                    parent.addAccountingEntry(new JCRAccountingFolderEntryRemoval(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.fireItemRemovedEvent(this.getWorkspaceItem(node));
                if (item.getType() == WorkspaceItemType.SHARED_FOLDER) {
                    try {
                        item.remove();
                        break block17;
                    }
                    catch (Exception e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                this.moveToTrash(node);
            }
            catch (javax.jcr.ItemNotFoundException e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (RemoteBackendException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (WrongDestinationException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemAlreadyExistException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (WorkspaceFolderNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            finally {
                session.logout();
            }
        }
    }

    public LockManager getLock(Node node) throws InternalErrorException {
        LockManager lockManager;
        block5: {
            lockManager = null;
            try {
                if (!node.isLocked()) break block5;
                this.logger.trace(node.getPath() + " is locked");
                lockManager = node.getSession().getWorkspace().getLockManager();
                Lock lock = null;
                try {
                    this.logger.trace("getting lock");
                    lock = lockManager.getLock(node.getPath());
                }
                catch (LockException ex) {
                    // empty catch block
                }
                if (lock != null) {
                    lockManager.addLockToken(lock.getLockToken());
                    node.getSession().save();
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        return lockManager;
    }

    public void moveToTrash(Node nodeToTrash) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, RepositoryException {
        Session session = nodeToTrash.getSession();
        long length = 0L;
        String mimeType = null;
        boolean isFolder = false;
        String name = nodeToTrash.getName();
        String description = "move to trash " + nodeToTrash.getName();
        String parentId = nodeToTrash.getParent().getIdentifier();
        String originalPath = null;
        try {
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(session, nodeToTrash.getIdentifier());
            if (!item.isShared()) {
                originalPath = item.getParent().getPath();
            }
            if (item.getType().equals((Object)WorkspaceItemType.FOLDER)) {
                isFolder = true;
            }
            try {
                mimeType = ((FolderItem)item).getMimeType();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                length = ((FolderItem)item).getLength();
            }
            catch (Exception e) {
                // empty catch block
            }
            Object usharedNode = null;
            try {
                Node trashNode = this.addChildNode(session, this.trashId, nodeToTrash.getIdentifier(), NT_TRASH_ITEM);
                new JCRWorkspaceTrashItem(this, trashNode, name, description, Calendar.getInstance(), this.getOwner().getPortalLogin(), parentId, mimeType, length, isFolder, originalPath);
                session.save();
                this.moveNodeTo(nodeToTrash, trashNode);
            }
            catch (InsufficientPrivilegesException | ItemAlreadyExistException | WorkspaceFolderNotFoundException | WrongDestinationException e) {
                throw new InternalErrorException(e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void checkDestination(Node node, Node destinationNode) throws WrongDestinationException, InternalErrorException, InsufficientPrivilegesException, ItemNotFoundException {
        try {
            Session session = node.getSession();
            if (destinationNode.getIdentifier().equals(this.trashId)) {
                return;
            }
            if (!(destinationNode.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) || destinationNode.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER) || destinationNode.getPrimaryNodeType().getName().equals(NT_TRASH_ITEM))) {
                this.logger.error("Destination is not a folder");
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (destinationNode.getIdentifier().equals(this.getMySpecialFoldersId())) {
                throw new WrongDestinationException("Not allowed to move files or folders in Special Folders");
            }
            JCRWorkspaceItem item = this.getWorkspaceItem(node);
            JCRWorkspaceItem itemDestination = this.getWorkspaceItem(destinationNode);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encode((String)Text.escapeIllegalJcrChars((String)item.getPath())) + "//element(*,nthl:workspaceSharedItem)", "xpath");
            QueryResult result = q.execute();
            if (itemDestination.isShared() && !item.isShared() && result.getNodes().hasNext() || itemDestination.isShared() && item.getType() == WorkspaceItemType.SHARED_FOLDER) {
                throw new WrongDestinationException("Not allowed to move in an other destination folder already shared");
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void moveItem(String itemId, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        this.logger.debug("Move item with id " + itemId + "to destination with id " + destinationFolderId);
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination folder id must be not null");
        Session session = JCRRepository.getSession();
        LockManager lockManager = null;
        Node nodeItem = null;
        try {
            lockManager = session.getWorkspace().getLockManager();
            try {
                nodeItem = session.getNodeByIdentifier(itemId);
            }
            catch (javax.jcr.ItemNotFoundException e) {
                this.logger.error("Item with id " + itemId + " not found");
                throw new ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                this.logger.error("Fatal error retrieving item with id " + itemId);
                throw new InternalErrorException((Throwable)e);
            }
            this.logger.trace(nodeItem.getPath() + " is locked? " + nodeItem.isLocked());
            if (!nodeItem.isLocked()) {
                Node nodeDestination;
                try {
                    Lock lock = lockManager.lock(nodeItem.getPath(), true, true, 0L, "");
                    this.logger.trace("LOCK on Node: " + lock.getNode().getPath());
                    session.save();
                }
                catch (Exception e) {
                    this.logger.trace("Unable to perform a locking operation on a non-lockable node: " + nodeItem.getPath());
                }
                try {
                    nodeDestination = session.getNodeByIdentifier(destinationFolderId);
                }
                catch (RepositoryException e) {
                    this.logger.error("Destination not found");
                    throw new WorkspaceFolderNotFoundException(e.getMessage());
                }
                try {
                    this.logger.trace("nodeDestination: " + nodeDestination.getPath());
                    this.checkDestination(nodeItem, nodeDestination);
                    JCRWorkspaceItem item = this.getWorkspaceItem(nodeItem);
                    if (item.isShared()) {
                        this.logger.debug("the item is shared: " + nodeItem.getPath());
                        if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), nodeItem.getPath(), false)) {
                            throw new InsufficientPrivilegesException("Insufficient Privileges to move the node");
                        }
                    }
                    JCRWorkspaceItem parentItem = (JCRWorkspaceItem)item.getParent();
                    JCRWorkspaceItem destinationItem = this.getWorkspaceItem(nodeDestination);
                    if (destinationItem.isShared() && !JCRPrivilegesInfo.canAddChildren(destinationItem.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), nodeDestination.getPath())) {
                        throw new InsufficientPrivilegesException("Insufficient Privileges to add the node");
                    }
                    this.logger.debug("Adding accounting entry ....");
                    try {
                        parentItem.addAccountingEntry(new JCRAccountingFolderEntryCut(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null));
                    }
                    catch (Exception e) {
                        this.logger.error("Error Set cut accounting entry to folder parent item ");
                    }
                    destinationItem.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null));
                    try {
                        item.addAccountingEntry(new JCRAccountingEntryPaste(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getParent().getName()));
                    }
                    catch (Exception e) {
                        this.logger.error("Error Set PASTE accounting entry to item ");
                    }
                    String newRemotePath = null;
                    if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                        newRemotePath = nodeDestination.getPath() + this.getPathSeparator() + item.getName();
                        try {
                            GCUBEStorage.moveRemoteFile(item.getRemotePath(), newRemotePath, this.home.getOwner().getPortalLogin());
                            JCRWorkspaceItem itemJCR = item;
                            itemJCR.setRemotePath(newRemotePath, nodeItem);
                        }
                        catch (Exception e) {
                            this.logger.error("Error setting remotePath to " + item.getPath());
                        }
                    } else if (item.getType() == WorkspaceItemType.FOLDER) {
                        newRemotePath = nodeDestination.getPath();
                        this.moveDir(item, newRemotePath, nodeItem);
                        session.save();
                    }
                    item.internalMove(nodeDestination);
                }
                catch (RepositoryException e) {
                    this.logger.error("Fatal error moving item with id " + itemId + " to WorkspaceFolder with id " + destinationFolderId);
                    throw new InternalErrorException((Throwable)e);
                }
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            try {
                if (lockManager.isLocked(nodeItem.getPath())) {
                    lockManager.unlock(nodeItem.getPath());
                    this.logger.trace("Remove Lock from node: " + nodeItem.getPath());
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            session.logout();
        }
    }

    private void moveDir(WorkspaceItem folder, String destinationPath, Node node) throws InternalErrorException {
        for (WorkspaceItem item : folder.getChildren()) {
            String path = destinationPath + this.getPathSeparator() + folder.getName() + this.getPathSeparator() + item.getName();
            try {
                String remotePath = item.getRemotePath();
                this.logger.trace("Update remotePath: " + remotePath + " to: " + path);
                GCUBEStorage.moveRemoteFile(remotePath, path, this.home.getOwner().getPortalLogin());
                this.logger.trace("moved from " + remotePath + " to " + path);
                JCRWorkspaceItem jcrItem = (JCRWorkspaceItem)item;
                jcrItem.setRemotePath(path, node);
                this.logger.trace("set Remote Path property to node: " + path);
                this.moveDir(item, path, node);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.warn("Error setting new remotePath to " + item.getName());
            }
        }
    }

    public void moveNodeTo(Node nodeItem, Node destinationNode) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)nodeItem, (String)"Node must be not null");
        Validate.notNull((Object)destinationNode, (String)"Destination folder Node must be not null");
        try {
            Session session = nodeItem.getSession();
            this.logger.debug("Move from " + nodeItem.getPath() + "to Trash ");
            try {
                JCRWorkspaceItem item = this.getWorkspaceItem(nodeItem);
                String newRemotePath = null;
                if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                    newRemotePath = destinationNode.getPath() + "/" + item.getName();
                    try {
                        GCUBEStorage.moveRemoteFile(item.getRemotePath(), newRemotePath, this.home.getOwner().getPortalLogin());
                        item.setRemotePath(newRemotePath, nodeItem);
                    }
                    catch (Exception e) {
                        this.logger.error("Error setting remotePath to " + item.getPath());
                    }
                } else if (item.getType() == WorkspaceItemType.FOLDER) {
                    newRemotePath = destinationNode.getPath();
                    this.moveDir(item, newRemotePath, nodeItem);
                    session.save();
                }
                item.internalMove(destinationNode);
            }
            catch (RepositoryException e) {
                this.logger.error("Fatal error moving item " + nodeItem.getPath() + " to WorkspaceFolder " + destinationNode.getPath());
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void moveSharedItem(Node sharedNode) throws ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, RepositoryException {
        Validate.notNull((Object)sharedNode, (String)"Item id must be not null");
        this.logger.debug("sharedFolder: " + sharedNode.getPath());
        Session session = JCRRepository.getSession();
        try {
            try {
                JCRWorkspaceItem item = this.getWorkspaceItem(sharedNode);
                if (item.isShared()) {
                    this.logger.debug("the item " + item.getPath() + " is shared");
                    if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), item.getPath(), false)) {
                        throw new InsufficientPrivilegesException("Insufficient Privileges to move the node");
                    }
                }
                String newRemotePath = null;
                this.logger.debug("item.getType() " + item.getType());
                if (item.getType() == WorkspaceItemType.SHARED_FOLDER) {
                    newRemotePath = sharedNode.getPath();
                    this.logger.debug("base Path " + newRemotePath);
                    this.moveToShare(item, newRemotePath);
                    this.logger.debug("moveToShare finished");
                }
            }
            catch (RepositoryException e) {
                this.logger.error("Fatal error moving item with id " + sharedNode);
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private void moveToShare(WorkspaceItem item, String destinationPath) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        this.logger.debug("WorkspaceItem " + item + " - destinationPath " + destinationPath);
        for (WorkspaceItem child : item.getChildren()) {
            String path = destinationPath + "/" + child.getName();
            this.logger.debug("path " + path);
            try {
                if (child.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) {
                    String remotePath = child.getRemotePath();
                    this.logger.debug("remotePath " + remotePath);
                    this.logger.trace("Update remotePath: " + remotePath + " to: " + path);
                    GCUBEStorage.moveRemoteFile(remotePath, path, this.home.getOwner().getPortalLogin());
                    this.logger.debug("moved from " + remotePath + " to " + path);
                    JCRWorkspaceItem JCRchild = (JCRWorkspaceItem)child;
                    JCRchild.setRemotePath(path, null);
                    this.logger.debug("property to node: " + child.getRemotePath() + " has been set");
                }
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            if (child.getChildren().size() <= 0) continue;
            this.moveToShare(child, path);
        }
    }

    public void renameItem(String itemId, String newName) throws ItemNotFoundException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        if (!this.isValidName(newName)) {
            throw new IllegalArgumentException("Invalid item name");
        }
        Session session = JCRRepository.getSession();
        try {
            Node parentNode;
            Node node;
            try {
                node = session.getNodeByIdentifier(itemId);
                parentNode = node.getParent();
            }
            catch (RepositoryException e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            JCRWorkspaceItem item = null;
            JCRWorkspaceItem parentItem = null;
            try {
                item = this.getWorkspaceItem(node);
                if (item.isShared()) {
                    this.logger.debug("the item is shared: " + node.getPath());
                    if (!JCRPrivilegesInfo.canModifyProperties(item.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), node.getPath(), false)) {
                        throw new InsufficientPrivilegesException("Insufficient Privileges to rename the node");
                    }
                }
                item.addAccountingEntry(new JCRAccountingEntryRenaming(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getName()));
                try {
                    parentItem = this.getWorkspaceItem(parentNode);
                    parentItem.addAccountingEntry(new JCRAccountingEntryRenaming(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getName()));
                }
                catch (Exception e) {
                    this.logger.error("Impossible to set rename operation to node " + parentNode.getPath());
                }
                item.internalRename(node, newName);
                String newRemotePath = null;
                if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
                    newRemotePath = parentNode.getPath() + this.getPathSeparator() + newName;
                    try {
                        GCUBEStorage.moveRemoteFile(item.getRemotePath(), newRemotePath, this.home.getOwner().getPortalLogin());
                        item.setRemotePath(newRemotePath, node);
                    }
                    catch (Exception e) {
                        this.logger.error("Error setting remotePath to " + item.getPath());
                    }
                } else if (item.getType() == WorkspaceItemType.FOLDER) {
                    newRemotePath = parentNode.getPath();
                    this.moveDir(item, newRemotePath, node);
                    session.save();
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
            this.fireItemRenamedEvent(item);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void changeDescription(String itemId, String newDescription) throws ItemNotFoundException, InternalErrorException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node nodeItem = session.getNodeByIdentifier(itemId);
            this.getWorkspaceItem(nodeItem).internalDescription(nodeItem, newDescription);
        }
        catch (RepositoryException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem getItem(String itemId) throws ItemNotFoundException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = null;
        try {
            session = JCRRepository.getSession();
            WorkspaceItem workspaceItem = this.getItem(session, itemId);
            return workspaceItem;
        }
        catch (InternalErrorException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public WorkspaceItem getItem(Session session, String itemId) throws ItemNotFoundException, InternalErrorException, RepositoryException {
        Node nodeItem = null;
        try {
            nodeItem = session.getNodeByIdentifier(itemId);
        }
        catch (javax.jcr.ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        return this.getWorkspaceItem(nodeItem);
    }

    public Capabilities getCapabilities(String itemId) throws ItemNotFoundException, InternalErrorException {
        return null;
    }

    public void removeChild(String childId, String folderId) throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongParentTypeException {
        Validate.notNull((Object)childId, (String)"Child Id must be not null");
        Validate.notNull((Object)folderId, (String)"Folder Id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node parent = session.getNodeByIdentifier(folderId);
            if (!parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                throw new WrongParentTypeException("Item with id " + folderId + " isn't a folder item");
            }
            this.removeItem(childId);
        }
        catch (javax.jcr.ItemNotFoundException e) {
            throw new ItemNotFoundException("Folder is not present");
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void remove(String itemName, String folderId) throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongItemTypeException {
        Session session = JCRRepository.getSession();
        try {
            Node nodeFolder = null;
            try {
                nodeFolder = session.getNodeByIdentifier(folderId);
            }
            catch (javax.jcr.ItemNotFoundException e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            try {
                Node childNode = nodeFolder.getNode(Text.escapeIllegalJcrChars((String)itemName));
                this.removeItem(childNode.getIdentifier());
            }
            catch (PathNotFoundException e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem copy(String itemId, String newName, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"ItemId must be not null");
        Validate.notNull((Object)newName, (String)"NewName must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination Folder id must be not null");
        if (!this.isValidName(newName)) {
            this.logger.error("The name contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        return this.internalCopy(itemId, newName, destinationFolderId);
    }

    public WorkspaceItem copy(String itemId, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"destinationFolder id must be not null");
        return this.internalCopy(itemId, null, destinationFolderId);
    }

    public void copyRemoteContent(Node node, Node nodeDestinationFolder) throws RepositoryException, InternalErrorException, RemoteBackendException {
        Session session = node.getSession();
        JCRWorkspaceItem item = this.getWorkspaceItem(node);
        for (WorkspaceItem child : item.getChildren()) {
            this.copyRemoteContent(session.getNodeByIdentifier(child.getId()), nodeDestinationFolder);
        }
        if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
            ((JCRWorkspaceFolderItem)item).copyRemoteContent(node);
            if (nodeDestinationFolder != null) {
                this.logger.debug("Set ADD accounting entry to destination folder " + nodeDestinationFolder.getPath());
                JCRWorkspaceItem destinationFolder = this.getWorkspaceItem(nodeDestinationFolder);
                destinationFolder.addAccountingEntry(new JCRAccountingFolderEntryAdd(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getType(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getFolderItemType() : null, item.getName(), item.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)item).getMimeType() : null));
                session.save();
            }
        }
    }

    private WorkspaceItem internalCopy(String itemId, String newName, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException, ItemAlreadyExistException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node nodeItem = null;
            try {
                nodeItem = session.getNodeByIdentifier(itemId);
            }
            catch (RepositoryException e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            Node nodeDestinationFolder = null;
            try {
                if (destinationFolderId == null) {
                    destinationFolderId = nodeItem.getParent().getIdentifier();
                }
                if (!(nodeDestinationFolder = session.getNodeByIdentifier(destinationFolderId)).getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) && !nodeDestinationFolder.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
                    throw new WrongDestinationException("Destination is not a folder");
                }
            }
            catch (RepositoryException e) {
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            JCRWorkspaceItem item = this.getWorkspaceItem(nodeItem);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encodePath((String)item.getPath()) + "//element(*,nthl:workspaceSharedItem)", "xpath");
            QueryResult result = q.execute();
            if (!item.isShared() && result.getNodes().hasNext()) {
                throw new WrongDestinationException("Not allowed to copy a folder with some discendents item shared ");
            }
            if (newName == null) {
                newName = item.getName();
            }
            Node newNode = this.getWorkspaceItem(nodeItem).internalCopy(nodeDestinationFolder, newName);
            session.save();
            JCRWorkspaceItem newItem = this.getWorkspaceItem(newNode);
            newItem.addAccountingEntry(new JCRAccountingEntryPaste(this.getOwner().getPortalLogin(), Calendar.getInstance(), item.getParent().getName()));
            this.copyRemoteContent(newNode, nodeDestinationFolder);
            session.save();
            JCRWorkspaceItem jCRWorkspaceItem = newItem;
            return jCRWorkspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem cloneItem(String itemId, String cloneName) throws ItemNotFoundException, ItemAlreadyExistException, InsufficientPrivilegesException, InternalErrorException, WrongDestinationException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"itemId must be not null");
        if (!this.isValidName(cloneName)) {
            throw new IllegalArgumentException("cloneName is a not valid name");
        }
        return this.internalCopy(itemId, cloneName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name, String folderId) throws InternalErrorException, ItemNotFoundException, WrongItemTypeException {
        Validate.notNull((Object)name, (String)"Name must be not null");
        Validate.notNull((Object)folderId, (String)"Name must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node folderNode;
            try {
                folderNode = session.getNodeByIdentifier(folderId);
            }
            catch (RepositoryException e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            if (!this.isValidName(name)) {
                boolean e = false;
                return e;
            }
            try {
                folderNode.getNode(Text.escapeIllegalJcrChars((String)name));
            }
            catch (RepositoryException e) {
                this.logger.debug("Item not exists");
                boolean bl = false;
                session.logout();
                return bl;
            }
            this.logger.debug("Item exists");
            boolean bl = true;
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String itemId) throws InternalErrorException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = JCRRepository.getSession();
        try {
            try {
                session.getNodeByIdentifier(itemId);
            }
            catch (RepositoryException e) {
                boolean bl = false;
                session.logout();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem find(String name, String folderId) throws InternalErrorException, ItemNotFoundException, WrongItemTypeException {
        Session session = JCRRepository.getSession();
        try {
            Node nodeFolder = session.getNodeByIdentifier(folderId);
            try {
                Node node = nodeFolder.getNode(Text.escapeIllegalJcrChars((String)name));
                JCRWorkspaceItem jCRWorkspaceItem = this.getWorkspaceItem(node);
                return jCRWorkspaceItem;
            }
            catch (PathNotFoundException e) {
                WorkspaceItem workspaceItem;
                try {
                    workspaceItem = null;
                }
                catch (javax.jcr.ItemNotFoundException e2) {
                    throw new ItemNotFoundException(e2.getMessage());
                }
                catch (RepositoryException e3) {
                    throw new InternalErrorException((Throwable)e3);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                session.logout();
                return workspaceItem;
            }
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem find(String path) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String[] strings = path.split("/");
            String pathCleaned = "";
            for (String string : strings) {
                pathCleaned = pathCleaned + "/" + Text.escapeIllegalJcrChars((String)string);
            }
            Node rootNode = session.getNodeByIdentifier(this.root.getId());
            Node node = session.getNode(rootNode.getPath() + pathCleaned);
            JCRWorkspaceItem jCRWorkspaceItem = this.getWorkspaceItem(node);
            return jCRWorkspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return !name.contains("/");
    }

    public FolderBulkCreator getNewFolderBulkCreator(String folderId) throws WorkspaceFolderNotFoundException, WrongItemTypeException, InternalErrorException {
        Validate.notNull((Object)folderId, (String)"Folder id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node folderNode;
            try {
                folderNode = session.getNodeByIdentifier(folderId);
            }
            catch (RepositoryException e) {
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            try {
                if (!folderNode.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                    throw new WrongItemTypeException("A FolderBulkCreator can be created  only for a folder");
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, folderNode);
            FolderBulkCreator folderBulkCreator = this.folderBulkCreatorsManager.getFolderBulk(folder);
            return folderBulkCreator;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public FolderBulkCreatorManager getFolderBulkCreatorManager() {
        return this.folderBulkCreatorsManager;
    }

    public WorkspaceMessageManager getWorkspaceMessageManager() {
        if (this.sendRequestManager == null) {
            this.sendRequestManager = new JCRWorkspaceMessageManager(this);
        }
        return this.sendRequestManager;
    }

    public WorkspaceFolder decomposeAquaMapsItem(String itemId, String folderName, String destinationWorkspaceId) throws WrongItemTypeException, WorkspaceFolderNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, ItemNotFoundException {
        return null;
    }

    public JCRWorkspaceItem getWorkspaceItem(Node node) throws RepositoryException, InternalErrorException {
        String type;
        switch (type = node.getPrimaryNodeType().getName()) {
            case "nthl:workspaceItem": {
                return new JCRWorkspaceFolder(this, node);
            }
            case "nthl:workspaceSharedItem": {
                return new JCRWorkspaceSharedFolder(this, node);
            }
            case "nthl:externalFile": {
                return new JCRExternalFile(this, node);
            }
            case "nthl:externalImage": {
                return new JCRExternalImage(this, node);
            }
            case "nthl:externalPdf": {
                return new JCRExternalPDFFile(this, node);
            }
            case "nthl:externalUrl": {
                return new JCRExternalUrl(this, node);
            }
            case "nthl:report": {
                return new JCRReport(this, node);
            }
            case "nthl:reportTemplate": {
                return new JCRReportTemplate(this, node);
            }
            case "nthl:workflowReport": {
                return new JCRWorkflowReport(this, node);
            }
            case "nthl:workflowTemplate": {
                return new JCRWorkflowTemplate(this, node);
            }
            case "nthl:aquamapsItem": {
                return new JCRAquaMapsItem(this, node);
            }
            case "nthl:query": {
                return new JCRQuery(this, node);
            }
            case "nthl:timeSeriesItem": {
                return new JCRTimeSeries(this, node);
            }
            case "nthl:gCubeDocument": {
                return new JCRDocument(this, node);
            }
            case "nthl:gCubeDocumentLink": {
                return new JCRDocumentLink(this, node);
            }
            case "nthl:gCubeImageDocument": {
                return new JCRImageDocument(this, node);
            }
            case "nthl:gCubeImageDocumentLink": {
                return new JCRImageDocumentLink(this, node);
            }
            case "nthl:gCubePDFDocument": {
                return new JCRPDFDocument(this, node);
            }
            case "nthl:gCubePDFDocumentLink": {
                return new JCRPDFDocumentLink(this, node);
            }
            case "nthl:gCubeURLDocument": {
                return new JCRUrlDocument(this, node);
            }
            case "nthl:gCubeAnnotation": {
                return new JCRAnnotation(this, node);
            }
            case "nthl:gCubeMetadata": {
                return new JCRMetadata(this, node);
            }
            case "nthl:workspaceLeafItem": {
                return new JCRWorkspaceSmartFolder(this, node);
            }
            case "nthl:externalResourceLink": {
                return new JCRExternalResourceLink(this, node);
            }
            case "nthl:gCubeItem": {
                return new JCRGCubeItem(this, node);
            }
            case "nthl:trashItem": {
                return new JCRWorkspaceTrashItem(this, node);
            }
        }
        throw new InternalErrorException("JCR node type unknow");
    }

    public FolderItemType getFolderItemType(Node node) throws RepositoryException {
        String nodeType = node.getPrimaryNodeType().getName();
        if (nodeType.equals(NT_WORKSPACE_FILE)) {
            return FolderItemType.EXTERNAL_FILE;
        }
        if (nodeType.equals(NT_WORKSPACE_IMAGE)) {
            return FolderItemType.EXTERNAL_IMAGE;
        }
        if (nodeType.equals(NT_WORKSPACE_PDF_FILE)) {
            return FolderItemType.EXTERNAL_PDF_FILE;
        }
        if (nodeType.equals(NT_WORKSPACE_URL)) {
            return FolderItemType.EXTERNAL_URL;
        }
        if (nodeType.equals(NT_WORKSPACE_REPORT)) {
            return FolderItemType.REPORT;
        }
        if (nodeType.equals(NT_WORKSPACE_REPORT_TEMPLATE)) {
            return FolderItemType.REPORT_TEMPLATE;
        }
        if (nodeType.equals(NT_WORKSPACE_WORKFLOW_REPORT)) {
            return FolderItemType.WORKFLOW_REPORT;
        }
        if (nodeType.equals(NT_WORKSPACE_WORKFLOW_TEMPLATE)) {
            return FolderItemType.WORKFLOW_TEMPLATE;
        }
        if (nodeType.equals(NT_AQUAMAPS_ITEM)) {
            return FolderItemType.AQUAMAPS_ITEM;
        }
        if (nodeType.equals(NT_QUERY)) {
            return FolderItemType.QUERY;
        }
        if (nodeType.equals(NT_TIMESERIES_ITEM)) {
            return FolderItemType.TIME_SERIES;
        }
        if (nodeType.equals(NT_DOCUMENT_ITEM)) {
            return FolderItemType.DOCUMENT;
        }
        if (nodeType.equals(NT_DOCUMENT_LINK_ITEM)) {
            return FolderItemType.DOCUMENT_LINK;
        }
        if (nodeType.equals(NT_IMAGE_DOCUMENT_ITEM)) {
            return FolderItemType.IMAGE_DOCUMENT;
        }
        if (nodeType.equals(NT_IMAGE_DOCUMENT_LINK_ITEM)) {
            return FolderItemType.IMAGE_DOCUMENT_LINK;
        }
        if (nodeType.equals(NT_PDF_DOCUMENT_ITEM)) {
            return FolderItemType.PDF_DOCUMENT;
        }
        if (nodeType.equals(NT_PDF_DOCUMENT_LINK_ITEM)) {
            return FolderItemType.PDF_DOCUMENT_LINK;
        }
        if (nodeType.equals(NT_URL_DOCUMENT_ITEM)) {
            return FolderItemType.URL_DOCUMENT;
        }
        if (nodeType.equals(NT_ANNOTATION_ITEM)) {
            return FolderItemType.ANNOTATION;
        }
        if (nodeType.equals(NT_METADATA_ITEM)) {
            return FolderItemType.METADATA_LINK;
        }
        if (nodeType.equals(NT_EXTERNAL_RESOURCE_LINK_ITEM)) {
            return FolderItemType.EXTERNAL_RESOURCE_LINK;
        }
        return null;
    }

    public JCRAbstractWorkspaceFolder getParent(Node node) throws RepositoryException, InternalErrorException {
        Node parent = node.getParent();
        if (parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
            return new JCRWorkspaceFolder(this, parent);
        }
        if (parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
            return new JCRWorkspaceSharedFolder(this, parent);
        }
        return null;
    }

    public JCRFile getGCUBEDocumentContent(Session session, String oid, ContentType contentType) throws RepositoryException {
        Node node = JCRRepository.getGCubeRoot(session).getNode(Text.escapeIllegalJcrChars((String)oid));
        switch (contentType) {
            case GENERAL: {
                return new JCRFile(this, node.getNode(CONTENT));
            }
            case IMAGE: {
                return new JCRImage(this, node.getNode(CONTENT));
            }
            case PDF: {
                return new JCRPDFFile(this, node.getNode(CONTENT));
            }
        }
        return null;
    }

    public JCRFile setGCUBEDocumentContent(Session session, String oid, InputStream data, String mimeType, ContentType contentType) throws IOException, ItemExistsException, RepositoryException, RemoteBackendException {
        Node parent = JCRRepository.getGCubeRoot(session);
        Node nodeFile = parent.addNode(Text.escapeIllegalJcrChars((String)oid), NT_FILE);
        JCRFile file = null;
        switch (contentType) {
            case GENERAL: {
                file = new JCRFile(this, nodeFile.addNode(CONTENT, ContentType.GENERAL.toString()), mimeType, data);
                break;
            }
            case IMAGE: {
                file = new JCRImage(this, nodeFile.addNode(CONTENT, ContentType.IMAGE.toString()), data);
                break;
            }
            case PDF: {
                file = new JCRPDFFile(this, nodeFile.addNode(CONTENT, ContentType.PDF.toString()), mimeType, data);
                break;
            }
        }
        return file;
    }

    private String isValidSearchResult(Node node) {
        String portalLogin = this.getHome().getOwner().getPortalLogin();
        String sharePath = "/Share";
        String userPath = "/Home/" + portalLogin;
        try {
            String nodePath = node.getPath();
            if (nodePath.startsWith(userPath)) {
                return node.getProperty("jcr:title").getString();
            }
            if (nodePath.startsWith(sharePath)) {
                Node sharedNode = (Node)node.getAncestor(2);
                Node usersNode = sharedNode.getNode(USERS);
                PropertyIterator iterator = usersNode.getProperties();
                while (iterator.hasNext()) {
                    Property property = iterator.nextProperty();
                    String name = property.getName();
                    if (!name.equals(portalLogin)) continue;
                    if (node.getPath().equals(sharedNode.getPath())) {
                        String[] values = property.getValue().getString().split("/");
                        return values[1];
                    }
                    return node.getName();
                }
            }
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public List<SearchItem> advancedSearch(String name, SearchItemByOperator date, SearchItemByOperator size) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        LinkedList<SearchItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            StringBuilder xpath = new StringBuilder("/jcr:root/Home/" + this.getOwner().getPortalLogin() + "/Workspace" + "//element(*,nthl:workspaceItem)[");
            xpath.append("jcr:contains(@jcr:title, '*" + name + "*')");
            if (date != null) {
                if (date.getMax() != null && date.getMin() != null) {
                    xpath.append(" and @jcr:created >= xs:dateTime('" + date.getMin() + "') and @jcr:created < xs:dateTime('" + date.getMax() + "')");
                } else {
                    xpath.append(" and @jcr:created " + date.getOperator() + " xs:dateTime('" + date.getValue().toString() + "')");
                }
            }
            if (size != null) {
                xpath.append(" and jcr:content/@hl:size");
            }
            xpath.append("]");
            Query q = queryManager.createQuery(xpath.toString(), "xpath");
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            list = new LinkedList<SearchItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node);
                if (itemName == null || !itemName.toUpperCase().contains(name.toUpperCase())) {
                    this.logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                try {
                    if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) || node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
                        list.add((SearchItem)new JCRSearchFolder(node, itemName));
                        continue;
                    }
                    list.add((SearchItem)new JCRSearchFolderItem(node, this.getFolderItemType(node), itemName));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error searchByName ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<SearchItem> searchByName(String name) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        LinkedList<SearchItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String userPath = "/Home/" + this.getOwner().getPortalLogin();
            String path = userPath + "/Workspace";
            String trashPath = path + "/Trash/";
            String sql2 = "SELECT * FROM [nthl:workspaceItem] AS node WHERE ISDESCENDANTNODE('" + path + "')" + " AND (UPPER([jcr:title]) LIKE '%" + name.toUpperCase() + "%')" + " AND NOT(ISDESCENDANTNODE ('" + trashPath + "'))";
            Query q = queryManager.createQuery(sql2, "JCR-SQL2");
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            list = new LinkedList<SearchItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node);
                if (itemName == null || !itemName.toUpperCase().contains(name.toUpperCase())) {
                    this.logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                try {
                    if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) || node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
                        list.add((SearchItem)new JCRSearchFolder(node, itemName));
                        continue;
                    }
                    list.add((SearchItem)new JCRSearchFolderItem(node, this.getFolderItemType(node), itemName));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error searchByName ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<WorkspaceItem> getWorkspaceTree(WorkspaceItem item) throws InternalErrorException {
        LinkedList<WorkspaceItem> listItems = new LinkedList<WorkspaceItem>();
        listItems.addAll(item.getChildren());
        for (WorkspaceItem child : item.getChildren()) {
            listItems.addAll(this.getWorkspaceTree(child));
        }
        return listItems;
    }

    public WorkspaceSmartFolder createSmartFolder(String name, String description, String query) throws ItemAlreadyExistException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = this.repository.getRootSmartFolders(session).addNode(name, NT_WORKSPACE_FOLDER_ITEM);
            JCRWorkspaceSmartFolder folder = new JCRWorkspaceSmartFolder(this, node, name, description, query);
            folder.save(node);
            JCRWorkspaceSmartFolder jCRWorkspaceSmartFolder = folder;
            return jCRWorkspaceSmartFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<WorkspaceSmartFolder> getAllSmartFolders() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        LinkedList<WorkspaceSmartFolder> folders = new LinkedList<WorkspaceSmartFolder>();
        try {
            NodeIterator iterator = this.repository.getRootSmartFolders(session).getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                folders.add(new JCRWorkspaceSmartFolder(this, node));
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return folders;
    }

    public WorkspaceSmartFolder getSmartFolder(String folderId) throws ItemNotFoundException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            JCRWorkspaceSmartFolder jCRWorkspaceSmartFolder = new JCRWorkspaceSmartFolder(this, session.getNodeByIdentifier(folderId));
            return jCRWorkspaceSmartFolder;
        }
        catch (javax.jcr.ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<SearchItem> getFolderItems(FolderItemType ... types) throws InternalErrorException {
        LinkedList<SearchItem> list = new LinkedList<SearchItem>();
        for (FolderItemType folderItemType : types) {
            list.addAll(this.getFolderItems(folderItemType));
        }
        return list;
    }

    public List<SearchItem> getFolderItems(FolderItemType type) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        NodeIterator iterator = null;
        LinkedList<SearchItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@hl:workspaceItemType = '" + type.toString() + "']", "xpath");
            QueryResult result = q.execute();
            iterator = result.getNodes();
            list = new LinkedList<SearchItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node);
                if (itemName == null) {
                    this.logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                try {
                    if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER) || node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_SHARED_FOLDER)) {
                        list.add((SearchItem)new JCRSearchFolder(node, itemName));
                        continue;
                    }
                    list.add((SearchItem)new JCRSearchFolderItem(node, this.getFolderItemType(node), itemName));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<SearchFolderItem> searchByProperties(List<String> properties) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        NodeIterator iterator = null;
        LinkedList<SearchFolderItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            StringBuilder query = new StringBuilder("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element(*,nthl:workspaceItem)[");
            int i = 0;
            for (String property : properties) {
                if (i != 0) {
                    query.append(" and ");
                }
                query.append("hl:property/@" + property + "");
                ++i;
            }
            query.append("]");
            this.logger.trace(query.toString());
            Query q = queryManager.createQuery(query.toString(), "xpath");
            QueryResult result = q.execute();
            iterator = result.getNodes();
            list = new LinkedList<SearchFolderItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node);
                if (itemName == null) {
                    this.logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                try {
                    list.add(new JCRSearchFolderItem(node.getParent(), this.getFolderItemType(node.getParent()), itemName));
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (RepositoryException e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<SearchFolderItem> searchByMimeType(String mimeType) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        NodeIterator iterator = null;
        LinkedList<SearchFolderItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:mimeType = '" + mimeType + "']", "xpath");
            QueryResult result = q.execute();
            iterator = result.getNodes();
            list = new LinkedList<SearchFolderItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node);
                if (itemName == null) {
                    this.logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                try {
                    list.add(new JCRSearchFolderItem(node.getParent(), this.getFolderItemType(node.getParent()), itemName));
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error("Item " + node.getName() + " unknow");
                    }
                    catch (RepositoryException e1) {
                        this.logger.error("Error ", (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    private String getJCRWorkspaceItemType(FolderItemType type) {
        switch (type) {
            case ANNOTATION: {
                return NT_ANNOTATION_ITEM;
            }
            case ANNOTATION_LINK: {
                return NT_ANNOTATION_LINK_ITEM;
            }
            case AQUAMAPS_ITEM: {
                return NT_AQUAMAPS_ITEM;
            }
            case DOCUMENT: {
                return NT_DOCUMENT_ITEM;
            }
            case DOCUMENT_LINK: {
                return NT_DOCUMENT_LINK_ITEM;
            }
            case EXTERNAL_FILE: {
                return NT_WORKSPACE_FILE;
            }
            case EXTERNAL_IMAGE: {
                return NT_WORKSPACE_IMAGE;
            }
            case EXTERNAL_PDF_FILE: {
                return NT_WORKSPACE_PDF_FILE;
            }
            case EXTERNAL_URL: {
                return NT_WORKSPACE_URL;
            }
            case IMAGE_DOCUMENT: {
                return NT_IMAGE_DOCUMENT_ITEM;
            }
            case IMAGE_DOCUMENT_LINK: {
                return NT_IMAGE_DOCUMENT_LINK_ITEM;
            }
            case METADATA: {
                return NT_METADATA_ITEM;
            }
            case METADATA_LINK: {
                return NT_METADATA_LINK_ITEM;
            }
            case PDF_DOCUMENT: {
                return NT_PDF_DOCUMENT_ITEM;
            }
            case PDF_DOCUMENT_LINK: {
                return NT_PDF_DOCUMENT_LINK_ITEM;
            }
            case QUERY: {
                return NT_QUERY;
            }
            case REPORT: {
                return NT_WORKSPACE_REPORT;
            }
            case REPORT_TEMPLATE: {
                return NT_WORKSPACE_REPORT_TEMPLATE;
            }
            case TIME_SERIES: {
                return NT_TIMESERIES_ITEM;
            }
            case URL_DOCUMENT: {
                return NT_URL_DOCUMENT_ITEM;
            }
            case WORKFLOW_REPORT: {
                return NT_WORKSPACE_WORKFLOW_REPORT;
            }
            case WORKFLOW_TEMPLATE: {
                return NT_WORKSPACE_WORKFLOW_TEMPLATE;
            }
        }
        return null;
    }

    public String getUrlWebDav() throws InternalErrorException {
        return this.repository.getWebDavUrl(this.home.getOwner().getPortalLogin()) + this.getPathSeparator() + WORKSPACE_ROOT_FOLDER;
    }

    private void updateHomes(List<String> users) throws InternalErrorException {
        try {
            List<String> homes = JCRRepository.getHomeNames();
            for (String user : users) {
                if (homes.contains(user)) continue;
                this.home.getHomeManager().createUser(user);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceSharedFolder createSharedFolder(String name, String description, List<String> users, String destinationFolderId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create workspace shared folder");
        this.updateHomes(users);
        Session session = JCRRepository.getSession();
        try {
            if (this.exists(name, destinationFolderId)) {
                throw new ItemAlreadyExistException("The item already exists");
            }
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(session, destinationFolderId);
            if (item.getType() != WorkspaceItemType.FOLDER) {
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (item.isShared()) {
                throw new WrongDestinationException("Destination folder is already shared");
            }
            Node sharedFolder = JCRRepository.getSharedRoot(session);
            Node node = sharedFolder.addNode(UUID.randomUUID().toString(), NT_WORKSPACE_SHARED_FOLDER);
            JCRWorkspaceSharedFolder folder = new JCRWorkspaceSharedFolder(this, node, name, description, destinationFolderId, users, null, null);
            folder.save(node);
            this.fireItemCreatedEvent(folder);
            JCRWorkspaceSharedFolder jCRWorkspaceSharedFolder = folder;
            return jCRWorkspaceSharedFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceSharedFolder shareFolder(List<String> users, String itemId) throws InternalErrorException, InsufficientPrivilegesException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.updateHomes(users);
        Session session = JCRRepository.getSession();
        LockManager lockManager = null;
        Node nodeItemToShare = null;
        JCRWorkspaceItem sharedItem = null;
        try {
            JCRWorkspaceItem itemToShare;
            lockManager = session.getWorkspace().getLockManager();
            nodeItemToShare = session.getNodeByIdentifier(itemId);
            if (!nodeItemToShare.isLocked()) {
                itemToShare = (JCRWorkspaceItem)this.getItem(session, itemId);
                if (itemToShare.getType() == WorkspaceItemType.SHARED_FOLDER) {
                    WorkspaceSharedFolder sharedFolder = (WorkspaceSharedFolder)itemToShare;
                    sharedFolder.share(users);
                    WorkspaceSharedFolder workspaceSharedFolder = sharedFolder;
                    return workspaceSharedFolder;
                }
                if (itemToShare.getType() != WorkspaceItemType.FOLDER && !(itemToShare instanceof GCubeItem)) {
                    throw new WorkspaceFolderNotFoundException("The item to share is not a folder");
                }
                JCRAbstractWorkspaceFolder parentItem = itemToShare.getParent(nodeItemToShare);
                if (parentItem == null) {
                    throw new WrongDestinationException("The root can't be shared");
                }
                String parentId = parentItem.getId();
                JCRWorkspaceItem destinationFolder = (JCRWorkspaceItem)this.getItem(session, parentId);
                if (destinationFolder.isShared()) {
                    throw new WrongDestinationException("Destination folder is already shared");
                }
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query q = queryManager.createQuery("/jcr:root/Home/" + this.getOwner().getPortalLogin() + ISO9075.encodePath((String)itemToShare.getPath()) + "//element(*,nthl:workspaceSharedItem)", "xpath");
                QueryResult result = q.execute();
                if (result.getNodes().hasNext()) {
                    throw new WrongDestinationException("Folder contains descendants already shared");
                }
                String sharedFolderName = itemToShare.getName();
                String sharedFolderDescription = itemToShare.getDescription();
                Node sharedRootFolder = JCRRepository.getSharedRoot(session);
                Node sharedNode = sharedRootFolder.addNode(sharedFolderName + UUID.randomUUID().toString(), NT_WORKSPACE_SHARED_FOLDER);
                if (itemToShare.getType() == WorkspaceItemType.FOLDER) {
                    sharedItem = new JCRWorkspaceSharedFolder(this, sharedNode, sharedFolderName, sharedFolderDescription, parentId, users, null, null);
                    NodeIterator iterator = nodeItemToShare.getNodes();
                    while (iterator.hasNext()) {
                        Node node = iterator.nextNode();
                        if (node.getName().startsWith("jcr:") || node.getName().startsWith("hl:")) continue;
                        session.getWorkspace().copy(node.getPath(), sharedNode.getPath() + this.getPathSeparator() + node.getName());
                    }
                } else {
                    String applicationName = nodeItemToShare.getParent().getName();
                    sharedItem = new JCRWorkspaceSharedFolder(this, sharedNode, sharedFolderName, sharedFolderDescription, parentId, users, applicationName, nodeItemToShare.getName());
                    session.getWorkspace().copy(nodeItemToShare.getPath(), sharedNode.getPath() + this.getPathSeparator() + nodeItemToShare.getName());
                    session.save();
                }
                try {
                    if (lockManager.isLocked(nodeItemToShare.getPath())) {
                        lockManager.unlock(nodeItemToShare.getPath());
                    }
                }
                catch (RepositoryException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                nodeItemToShare.remove();
                session.save();
                ((JCRWorkspaceSharedFolder)sharedItem).save(sharedNode);
                sharedItem.setShareHistory(users, this.getOwner().getPortalLogin());
                if (itemToShare.getType() == WorkspaceItemType.FOLDER) {
                    try {
                        this.moveSharedItem(sharedNode);
                    }
                    catch (ItemAlreadyExistException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    session.save();
                    sharedItem.setShareHistory(users, this.getOwner().getPortalLogin());
                }
                this.fireItemCreatedEvent(sharedItem);
            }
            itemToShare = sharedItem;
            return itemToShare;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public TabularDataLink createTabularDataLink(String name, String description, String tableId, String template, TabularDataLink.Provenance provenance, String operator, String runtimeResourceName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create tabular data link");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_TABULAR_DATA_LINK);
            JCRTabularDataLink item = new JCRTabularDataLink(this, node, name, description, tableId, template, provenance, operator, runtimeResourceName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRTabularDataLink jCRTabularDataLink = item;
            return jCRTabularDataLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<Object> getBookmarks(String bookmarkFolderId) throws InternalErrorException {
        return null;
    }

    public void addBookmark(String itemId, String destinationFolderId) throws ItemAlreadyExistException, InternalErrorException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
    }

    public void setHardLink(Node node, String hardLinkRemotePath) throws RepositoryException, InternalErrorException {
        this.logger.info("set hard link: " + hardLinkRemotePath + " to node " + node.getPath());
        Session session = node.getSession();
        JCRWorkspaceItem item = this.getWorkspaceItem(node);
        for (WorkspaceItem child : item.getChildren()) {
            this.setHardLink(session.getNodeByIdentifier(child.getId()), hardLinkRemotePath);
        }
        if (item.getType() == WorkspaceItemType.FOLDER_ITEM) {
            ((JCRWorkspaceFolderItem)item).setHardLink(node, hardLinkRemotePath);
        }
        session.save();
    }

    public void orderResultBy(String mimeType, long limit, long offset) throws InternalErrorException {
    }

    public void updateItem(String itemId, InputStream fileData) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(itemId);
            this.logger.trace("Update file " + node.getPath());
            JCRWorkspaceItem newItem = this.getWorkspaceItem(node);
            if (newItem.isShared()) {
                this.logger.debug("the item is shared: " + node.getPath());
                if (!JCRPrivilegesInfo.canModifyProperties(newItem.getOwner().getPortalLogin(), this.getOwner().getPortalLogin(), node.getPath(), false)) {
                    throw new InsufficientPrivilegesException("Insufficient Privileges to update the node");
                }
            }
            Calendar lastupdate = Calendar.getInstance();
            newItem.addAccountingEntry(new JCRAccountingEntryUpdate(this.getOwner().getPortalLogin(), lastupdate, node.getName()));
            Node parent = node.getParent();
            JCRWorkspaceItem parentItem = this.getWorkspaceItem(parent);
            parentItem.addAccountingEntry(new JCRAccountingEntryUpdate(this.getOwner().getPortalLogin(), lastupdate, node.getName()));
            File tmpFile = WorkspaceUtil.getTmpFile((InputStream)fileData);
            FileInputStream data = null;
            try {
                data = new FileInputStream(tmpFile);
                this.overwriteContent(node, data);
                ((InputStream)data).close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            FileInputStream dataUpdate = null;
            try {
                dataUpdate = new FileInputStream(tmpFile);
                this.updateProperties(node, dataUpdate, lastupdate);
                ((InputStream)dataUpdate).close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.fireItemUpdatedEvent(this.getItem(itemId));
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private void updateProperties(Node node, InputStream fileData, Calendar lastupdate) throws RepositoryException, InternalErrorException, RemoteBackendException, IOException {
        node.setProperty(LAST_MODIFIED, lastupdate);
        node.setProperty(LAST_MODIFIED_BY, this.getOwner().getPortalLogin());
        node.setProperty(LAST_ACTION, WorkspaceItemAction.UPDATED.toString());
        node.getSession().save();
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FILE)) {
            JCRExternalFile item = new JCRExternalFile(this, node);
            item.updateInfo();
        } else if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_IMAGE)) {
            JCRExternalImage item = new JCRExternalImage(this, node);
            item.updateInfo();
        } else if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_PDF_FILE)) {
            JCRExternalPDFFile item = new JCRExternalPDFFile(this, node);
            item.updateInfo();
        }
    }

    public void overwriteContent(Node node, String is) throws RepositoryException, RemoteBackendException {
        try {
            Node contentNode = node.getNode(CONTENT);
            if (contentNode.hasProperty("hl:remotePath")) {
                String remotePath = contentNode.getProperty("hl:remotePath").getString();
                String url = GCUBEStorage.putStream(is, remotePath, this.home.getOwner().getPortalLogin());
                ByteArrayInputStream binaryUrl = new ByteArrayInputStream(url.getBytes());
                Binary binary = contentNode.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
                contentNode.setProperty("jcr:data", binary);
            }
        }
        catch (PathNotFoundException e) {
            this.logger.error("Content node jcr:content not found", (Throwable)e);
        }
    }

    public void overwriteContent(Node node, InputStream is) throws RepositoryException, RemoteBackendException {
        try {
            Node contentNode = node.getNode(CONTENT);
            if (contentNode.hasProperty("hl:remotePath")) {
                String remotePath = contentNode.getProperty("hl:remotePath").getString();
                String url = GCUBEStorage.putStream(is, remotePath, this.home.getOwner().getPortalLogin());
                ByteArrayInputStream binaryUrl = new ByteArrayInputStream(url.getBytes());
                Binary binary = contentNode.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
                contentNode.setProperty("jcr:data", binary);
            }
        }
        catch (PathNotFoundException e) {
            this.logger.error("Content node jcr:content not found", (Throwable)e);
        }
    }

    public JCRWorkspaceItem createGcubeItem(String name, String description, List<String> scopes, String creator, String itemType, Map<String, String> properties, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException {
        this.logger.trace("Create aquamaps item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_GCUBE_ITEM);
            JCRGCubeItem item = new JCRGCubeItem(this, node, name, description, scopes, creator, itemType, properties);
            session.save();
            this.fireItemCreatedEvent(item);
            JCRGCubeItem jCRGCubeItem = item;
            return jCRGCubeItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public JCRWorkspaceFolder getApplicationArea() {
        return this.applicationFolder;
    }

    public WorkspaceItem unshare(String itemId) throws InternalErrorException, ItemNotFoundException {
        WorkspaceItem itemUnshared = null;
        Session session = JCRRepository.getSession();
        LockManager lockManager = null;
        Node sharedNode = null;
        try {
            lockManager = session.getWorkspace().getLockManager();
            sharedNode = session.getNodeByIdentifier(itemId);
            if (!sharedNode.isLocked()) {
                JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(sharedNode.getIdentifier());
                if (item.isShared()) {
                    JCRWorkspaceSharedFolder sharedItem = new JCRWorkspaceSharedFolder(this, sharedNode);
                    WorkspaceFolder destFolder = sharedItem.unShare();
                    this.logger.trace("Unshared Folder: " + destFolder.getPath());
                } else {
                    this.logger.trace(item.getPath() + " the item is not shared");
                }
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            try {
                if (lockManager.isLocked(sharedNode.getPath())) {
                    lockManager.unlock(sharedNode.getPath());
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            session.logout();
        }
        return itemUnshared;
    }

    public WorkspaceItem getItemByPath(String path) throws ItemNotFoundException {
        Validate.notNull((Object)path, (String)"path must be not null");
        Session session = null;
        try {
            session = JCRRepository.getSession();
            String absPath = this.userHomePath + path;
            WorkspaceItem workspaceItem = this.getItemByAbsPath(session, absPath);
            return workspaceItem;
        }
        catch (InternalErrorException e) {
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public WorkspaceItem getItemByAbsPath(Session session, String path) throws ItemNotFoundException, InternalErrorException, RepositoryException {
        Node nodeItem = null;
        try {
            nodeItem = session.getNode(path);
        }
        catch (javax.jcr.ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        return this.getWorkspaceItem(nodeItem);
    }

    public WorkspaceTrashFolder getTrash() throws InternalErrorException, ItemNotFoundException {
        Session session = JCRRepository.getSession();
        try {
            JCRWorkspaceTrashFolder jCRWorkspaceTrashFolder = new JCRWorkspaceTrashFolder(this, session.getNodeByIdentifier(this.trashId));
            return jCRWorkspaceTrashFolder;
        }
        catch (javax.jcr.ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getTrashId() {
        return this.trashId;
    }

    public WorkspaceSharedFolder createSharedFolder(String name, String description, String groupId, String destinationFolderId, String displayName, boolean isVREFolder) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace("Create workspace shared folder");
        String newName = this.cleanName(name);
        String newGroupId = this.cleanName(groupId);
        List<String> users = this.resolveGroupId(newGroupId);
        this.updateHomes(users);
        Session session = JCRRepository.getSession();
        try {
            String destinationFolder = this.getMySpecialFoldersId();
            if (this.exists(newName, destinationFolder)) {
                throw new ItemAlreadyExistException("The item already exists");
            }
            JCRWorkspaceItem item = (JCRWorkspaceItem)this.getItem(session, destinationFolder);
            if (item.getType() != WorkspaceItemType.FOLDER) {
                throw new WrongDestinationException("Destination is not a folder");
            }
            if (item.isShared()) {
                throw new WrongDestinationException("Destination folder is already shared");
            }
            Node sharedFolder = JCRRepository.getSharedRoot(session);
            Node node = sharedFolder.addNode(UUID.randomUUID().toString(), NT_WORKSPACE_SHARED_FOLDER);
            ArrayList<String> users1 = new ArrayList<String>();
            users1.add(newGroupId);
            JCRWorkspaceSharedFolder folder = new JCRWorkspaceSharedFolder(this, node, newName, description, destinationFolder, users1, null, null, displayName, isVREFolder);
            folder.save(node);
            this.fireItemCreatedEvent(folder);
            if (isVREFolder) {
                this.createVREManager(newName, folder);
            }
            JCRWorkspaceSharedFolder jCRWorkspaceSharedFolder = folder;
            return jCRWorkspaceSharedFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private void createVREManager(String newName, JCRWorkspaceSharedFolder folder) throws InsufficientPrivilegesException, WrongDestinationException, InternalErrorException {
        String manager = newName + "-Manager";
        ArrayList<String> usersList = new ArrayList<String>();
        usersList.add(manager);
        folder.share(usersList);
    }

    private String cleanName(String oldName) {
        String newName = oldName.startsWith("/") ? oldName.replace("/", "-").substring(1) : oldName.replace("/", "-");
        return newName;
    }

    public List<String> resolveGroupId(String groupId) throws InternalErrorException {
        UserManager gm = HomeLibrary.getHomeManagerFactory().getUserManager();
        GCubeGroup myGroup = gm.getGroup(groupId);
        List members = myGroup.getMembers();
        return members;
    }

    public String getMySpecialFoldersId() {
        return this.mySpecialFoldersId;
    }

    public WorkspaceFolder getMySpecialFolders() throws InternalErrorException, ItemNotFoundException {
        Session session = JCRRepository.getSession();
        try {
            JCRWorkspaceFolder jCRWorkspaceFolder = new JCRWorkspaceFolder(this, session.getNodeByIdentifier(this.getMySpecialFoldersId()));
            return jCRWorkspaceFolder;
        }
        catch (javax.jcr.ItemNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }
}

