/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.data;

import java.util.List;
import javax.jcr.Session;
import org.gcube.common.homelibrary.home.data.ApplicationsArea;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;

public class JCRApplicationsArea
implements ApplicationsArea {
    private static final String SHARE = "share";
    private static final String USERS = "users";
    private JCRWorkspaceFolder applicationsArea;
    private JCRWorkspace worksapce;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCRApplicationsArea(JCRWorkspace workspace, JCRRepository repository) {
        this.worksapce = workspace;
        Session session = null;
        try {
            session = JCRRepository.getSession();
            this.applicationsArea = workspace.getApplicationArea();
        }
        catch (InternalErrorException e) {
        }
        finally {
            session.logout();
        }
    }

    private WorkspaceFolder getApplicationRoot(Session session, String applicationName) throws InternalErrorException {
        try {
            WorkspaceFolder folder = (WorkspaceFolder)this.applicationsArea.find(applicationName);
            if (folder == null) {
                folder = this.applicationsArea.createFolder(applicationName, applicationName);
            }
            WorkspaceFolder workspaceFolder = folder;
            return workspaceFolder;
        }
        catch (InsufficientPrivilegesException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceFolder getApplicationRoot(String applicationName) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        return this.getApplicationRoot(session, applicationName);
    }

    public List<String> listApplicationNames() throws InternalErrorException {
        return null;
    }

    public WorkspaceFolder getApplicationUserRoot(String applicationName) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        WorkspaceFolder applicationsRoot = this.getApplicationRoot(applicationName);
        try {
            WorkspaceFolder usersFolder = (WorkspaceFolder)applicationsRoot.find(USERS);
            WorkspaceFolder userFolder = (WorkspaceFolder)usersFolder.find(this.worksapce.getOwner().getPortalLogin());
            if (userFolder == null) {
                userFolder = usersFolder.createFolder(this.worksapce.getOwner().getPortalLogin(), applicationName);
            }
            WorkspaceFolder workspaceFolder = userFolder;
            return workspaceFolder;
        }
        catch (InsufficientPrivilegesException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceFolder getApplicationShareRoot(String applicationName) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        WorkspaceFolder applicationsRoot = this.getApplicationRoot(applicationName);
        try {
            WorkspaceFolder shareFolder;
            WorkspaceFolder workspaceFolder = shareFolder = (WorkspaceFolder)applicationsRoot.find(SHARE);
            return workspaceFolder;
        }
        finally {
            session.logout();
        }
    }
}

