/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube.JCRDocument;
import org.gcube.common.homelibrary.util.Util;

public class JCRUrlDocument
extends JCRDocument
implements UrlDocument {
    public JCRUrlDocument(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
        super(workspace, node);
    }

    public JCRUrlDocument(JCRWorkspace workspace, Node node, String name, String description, String objectId, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName) throws RepositoryException, InternalErrorException {
        super(workspace, node, name, description, objectId, mimeType, documentData, metadata, annotations, collectionName);
        node.setProperty("hl:workspaceItemType", FolderItemType.URL_DOCUMENT.toString());
    }

    public String getUrl() throws InternalErrorException {
        try {
            return Util.readStreamAsString((InputStream)this.documentContent.getData());
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.URL_DOCUMENT;
    }
}

