/**
 * 
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryPaste;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryType;

/**
 * @author Antonio Gioia antonio.gioia@isti.cnr.it
 *
 */
public class JCRAccountingEntryPaste extends JCRAccountingEntry implements AccountingEntryPaste {

	private static final String FROM_PATH 		= "hl:fromPath";
	
	private final String fromPath;
	
	public JCRAccountingEntryPaste(Node node) throws RepositoryException {
		super(node);
		
		this.fromPath = node.getProperty(FROM_PATH).getString();
	}

	public JCRAccountingEntryPaste(String user, Calendar date,
			 String fromPath) {
		super(user,date);
		
		this.fromPath = fromPath;
	}

	@Override
	public String getFromPath() {
		return fromPath;
	}

	@Override
	public void save(Node entryNode) throws RepositoryException {
		super.save(entryNode);
	
		entryNode.setProperty(FROM_PATH, fromPath);
	}

	@Override
	public AccountingEntryType getEntryType() {
		return AccountingEntryType.PASTE;
	}

	@Override
	public String toString() {
		String parentValue = super.toString();
		return String.format("[%s [%s, fromPath:%s]]",parentValue, AccountingEntryType.PASTE, fromPath);
	}


}
