/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.manager.HomeLibraryManager;
import org.gcube.common.homelibrary.jcr.JCRExternalResourcePluginManager;
import org.gcube.common.homelibrary.jcr.JCRHomeManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRHomeManagerFactory
implements HomeManagerFactory {
    private static Logger logger = LoggerFactory.getLogger(JCRHomeManagerFactory.class);
    private static HomeManager homeManager;
    private static File persistenceFolder;

    public void initialize(String pathPersistenceFolder) throws InternalErrorException {
        logger.debug("Initialize content manager");
        try {
            JCRRepository.Initialize();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        JCRExternalResourcePluginManager.initialize();
        homeManager = new JCRHomeManager(this);
    }

    public File getPersistenceFolder() {
        return persistenceFolder;
    }

    public List<String> listScopes() throws InternalErrorException {
        LinkedList<String> list = new LinkedList<String>();
        return list;
    }

    public boolean exists(String scope) throws InternalErrorException {
        return false;
    }

    public HomeLibraryManager getHomeLibraryManager() throws InternalErrorException {
        return null;
    }

    public List<String> listUserScopes(String portalLogin) throws InternalErrorException {
        try {
            Home home = homeManager.getHome(portalLogin);
            return home.listScopes();
        }
        catch (HomeNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<String> listInfrastructureScopes() throws InternalErrorException {
        return null;
    }

    public List<String> listInfrastructureScopeUsers(String scope) throws InternalErrorException {
        return null;
    }

    public void shutdown() throws InternalErrorException {
    }

    public HomeManager getHomeManager() throws InternalErrorException {
        logger.debug("getHomeManager");
        return homeManager;
    }

    public void removeHomeManager() throws InternalErrorException {
    }

    public HomeManager getHomeManager(String scope) throws InternalErrorException {
        return this.getHomeManager();
    }
}

