package org.gcube.common.homelibrary.client;

import org.gcube.common.homelibrary.client.util.Command;
import org.gcube.common.homelibrary.client.util.Config;

public class EntryPoint {

	public static void main(String[] args) {

		for (int i=0; i<args.length;i++) 
			System.out.println("param N." +i + ": " + args[i]);

		if (args.length >= 1){
			switch (args[0]) {			
			case Command.CREATE_FOLDER:

				if((args.length != 2) && (args.length != 4)){
					System.out.println("Usage:");
					System.out.println("\tjava -jar " + Config.JAR + " " + Command.CREATE_FOLDER + " foldername destinationFolder description\n\n");
					System.out.println("Example:");
					System.out.println("\tjava -jar " + Config.JAR + " " + Command.CREATE_FOLDER + " TestFolder mypath/user/myWorkspace 'my Folder' \n\n");
					return;
				}else{
					String folderName = args[1];

					String destinationPath = null;
					if (args.length > 2)
						destinationPath = args[2];

					String description = null;
					if (args.length > 3)
						description = args[3];

					new Mkdir(folderName, destinationPath, description);
				}

				break;
			case Command.LIST_FOLDER:

				if((args.length > 2)){
					System.out.println("Usage:");
					System.out.println("\tjava -jar " + Config.JAR + " " + Command.LIST_FOLDER + " foldername\n\n");
					System.out.println("Example:");
					System.out.println("\tjava -jar " + Config.JAR + " " + Command.LIST_FOLDER + " myPersonalFolder \n\n");
					return;
				}else{
					String folderName = null;
					if (args.length > 1)	
						folderName = args[1];
					new ListFolder(folderName);
				}			

				break;
			case Command.DELETE:

				if((args.length != 2)){
					System.out.println("Usage:");
					System.out.println("\tjava -jar " + Config.JAR + " " + Command.DELETE + " foldername\n\n");
					System.out.println("Example:");
					System.out.println("\tjava -jar " + Config.JAR + " " + Command.DELETE + " myPersonalFolder \n\n");
					return;
				}else{
					String path = args[1];
					new Delete(path);
				}
				break;
			case Command.SAVE:
				if((args.length <= 2) && (args.length >= 4)){
					System.out.println("Usage:");
					System.out.println("\tjava -jar " + Config.JAR + " " + Command.SAVE + " URL destinationPath name\n\n");
					System.out.println("Example:");
					System.out.println("\tjava -jar " + Config.JAR + " " + Command.SAVE + " /home/user/Downloads/image.jpg mydir newName \n\n");
					return;
				}else{
					String fileUrl = args[1];

					String parentPath = null;
					if (args.length > 2)
						parentPath = args[2];

					String name = null;
					if (args.length > 3)
						name = args[3];

					new UploadFile(fileUrl, parentPath, name);
				}
				break;
			case Command.TEST:
				new Test();
				break;
			default:
				System.out.println("Command not allowed");
				break;
			}

		}

		if(args.length < 1){
			System.err.println("Usage: java -jar " + Config.JAR + " <command>");
			System.err.println("Where <command> is:");
			System.err.println("\t" +Command.CREATE_FOLDER);
			System.err.println("\t" +Command.LIST_FOLDER);
			System.err.println("\t" +Command.DELETE);
			System.err.println("\t" +Command.SAVE);
			System.err.println("\t" +Command.TEST);
			System.exit(1);
			//			System.out.println("\tjava  Save  URL destinationPath name \n\n");
			//			System.out.println("Usage:");
			//			System.out.println("\tjava  Save  URL destinationPath name \n\n");
			//			System.out.println("Example:");
			//			System.out.println("\tjava  Save /home/user/Downloads/image.jpg mydir newName\n\n");
			//			return;
		}
	}

}
