package org.gcube.common.homelibrary.client;

import java.util.List;

import org.gcube.common.homelibrary.client.servlet.Servlets;
import org.gcube.common.homelibrary.client.util.Config;

public class ListFolder {

	public ListFolder(String folderName) {

		String absPath = Config.ROOT_PATH;
		if (folderName != null)
			absPath = Config.ROOT_PATH + folderName;

		try {
			listFolder(absPath);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}



	private static void listFolder(String name) throws Exception {

		try{
			List<String> folder = Servlets.listFolder(name);
			if (folder!=null){
				System.out.println(folder.size() + " items found.");
				for(String item: folder)
					System.out.println(item.replace(Config.ROOT_PATH, ""));
			}

		}catch (Exception e){
			e.printStackTrace();
		}

	}

}
