/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.lazy.initializor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.lazy.initializor.AbstractCollectionInitializor;
import org.hibernate.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.reader.AuditReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCollectionInitializor
extends AbstractCollectionInitializor<List> {
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public ListCollectionInitializor(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(verCfg, versionsReader, queryGenerator, primaryKey, revision);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected List initializeCollection(int size) {
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
        return list;
    }

    @Override
    protected void addToCollection(List collection, Object collectionRow) {
        Object elementData = ((List)collectionRow).get(this.elementComponentData.getComponentIndex());
        Object element = this.elementComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)elementData, null, this.revision);
        Object indexData = ((List)collectionRow).get(this.indexComponentData.getComponentIndex());
        Object indexObj = this.indexComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)indexData, element, this.revision);
        int index = ((Number)indexObj).intValue();
        collection.set(index, element);
    }
}

