/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.TableGenerator;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableHiLoGenerator
extends TableGenerator {
    public static final String MAX_LO = "max_lo";
    private int maxLo;
    private int lo;
    private IntegralDataTypeHolder value;
    private static final Logger log = LoggerFactory.getLogger((Class)TableHiLoGenerator.class);

    public void configure(Type type, Properties params, Dialect d) {
        super.configure(type, params, d);
        this.maxLo = PropertiesHelper.getInt(MAX_LO, params, Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) {
        if (this.maxLo < 1) {
            IntegralDataTypeHolder value = null;
            while (value == null || value.lt(0L)) {
                value = this.generateHolder(session);
            }
            return value.makeValue();
        }
        if (this.lo > this.maxLo) {
            IntegralDataTypeHolder hiVal = this.generateHolder(session);
            this.lo = hiVal.eq(0L) ? 1 : 0;
            this.value = hiVal.copy().multiplyBy(this.maxLo + 1).add(this.lo);
            if (log.isDebugEnabled()) {
                log.debug("new hi value: " + hiVal);
            }
        }
        return this.value.makeValueThenIncrement();
    }
}

