/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.CriteriaTools;
import org.hibernate.envers.query.property.PropertyNameGetter;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public class InAuditExpression
implements AuditCriterion {
    private PropertyNameGetter propertyNameGetter;
    private Object[] values;

    public InAuditExpression(PropertyNameGetter propertyNameGetter, Object[] values) {
        this.propertyNameGetter = propertyNameGetter;
        this.values = values;
    }

    public void addToQuery(AuditConfiguration auditCfg, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = this.propertyNameGetter.get(auditCfg);
        CriteriaTools.checkPropertyNotARelation(auditCfg, entityName, propertyName);
        parameters.addWhereWithParams(propertyName, "in (", this.values, ")");
    }
}

