/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.ImmutableType;

public class StringType
extends ImmutableType
implements DiscriminatorType {
    public Object get(ResultSet rs, String name) throws SQLException {
        return rs.getString(name);
    }

    public Class getReturnedClass() {
        return String.class;
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setString(index, (String)value);
    }

    public int sqlType() {
        return 12;
    }

    public String getName() {
        return "string";
    }

    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return '\'' + (String)value + '\'';
    }

    public Object stringToObject(String xml) throws Exception {
        return xml;
    }

    public String toString(Object value) {
        return (String)value;
    }

    public Object fromStringValue(String xml) {
        return xml;
    }
}

