/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl.bridge;

import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cfg.Settings;

public class CollectionAccessStrategyAdapter
implements CollectionRegionAccessStrategy {
    private final CollectionRegion region;
    private final CacheConcurrencyStrategy ccs;
    private final Settings settings;

    public CollectionAccessStrategyAdapter(CollectionRegion region, CacheConcurrencyStrategy ccs, Settings settings) {
        this.region = region;
        this.ccs = ccs;
        this.settings = settings;
    }

    public CollectionRegion getRegion() {
        return this.region;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.ccs.get(key, txTimestamp);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.putFromLoad(key, value, txTimestamp, version, this.settings.isMinimalPutsEnabled());
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.ccs.put(key, value, txTimestamp, version, this.region.getCacheDataDescription().getVersionComparator(), minimalPutOverride);
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return this.ccs.lock(key, version);
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.ccs.release(key, lock);
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
        if (!this.region.isTransactionAware()) {
            this.ccs.clear();
        }
    }

    public void remove(Object key) throws CacheException {
        this.ccs.evict(key);
    }

    public void removeAll() throws CacheException {
        this.ccs.clear();
    }

    public void evict(Object key) throws CacheException {
        this.ccs.remove(key);
    }

    public void evictAll() throws CacheException {
        this.ccs.clear();
    }

    public void destroy() {
        this.ccs.destroy();
    }
}

