/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.EntityModeToTuplizerMapping;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.tuple.entity.EntityTuplizerFactory;

public class EntityEntityModeToTuplizerMapping
extends EntityModeToTuplizerMapping
implements Serializable {
    public EntityEntityModeToTuplizerMapping(PersistentClass mappedEntity, EntityMetamodel em) {
        String tuplizerImplClassName;
        EntityTuplizerFactory entityTuplizerFactory = em.getSessionFactory().getSettings().getEntityTuplizerFactory();
        HashMap userSuppliedTuplizerImpls = new HashMap();
        if (mappedEntity.getTuplizerMap() != null) {
            userSuppliedTuplizerImpls.putAll(mappedEntity.getTuplizerMap());
        }
        EntityTuplizer dynamicMapTuplizer = (tuplizerImplClassName = (String)userSuppliedTuplizerImpls.remove(EntityMode.MAP)) == null ? entityTuplizerFactory.constructDefaultTuplizer(EntityMode.MAP, em, mappedEntity) : entityTuplizerFactory.constructTuplizer(tuplizerImplClassName, em, mappedEntity);
        tuplizerImplClassName = (String)userSuppliedTuplizerImpls.remove(EntityMode.POJO);
        EntityTuplizer pojoTuplizer = mappedEntity.hasPojoRepresentation() ? (tuplizerImplClassName == null ? entityTuplizerFactory.constructDefaultTuplizer(EntityMode.POJO, em, mappedEntity) : entityTuplizerFactory.constructTuplizer(tuplizerImplClassName, em, mappedEntity)) : dynamicMapTuplizer;
        tuplizerImplClassName = (String)userSuppliedTuplizerImpls.remove(EntityMode.DOM4J);
        EntityTuplizer dom4jTuplizer = mappedEntity.hasDom4jRepresentation() ? (tuplizerImplClassName == null ? entityTuplizerFactory.constructDefaultTuplizer(EntityMode.DOM4J, em, mappedEntity) : entityTuplizerFactory.constructTuplizer(tuplizerImplClassName, em, mappedEntity)) : null;
        if (pojoTuplizer != null) {
            this.addTuplizer(EntityMode.POJO, pojoTuplizer);
        }
        if (dynamicMapTuplizer != null) {
            this.addTuplizer(EntityMode.MAP, dynamicMapTuplizer);
        }
        if (dom4jTuplizer != null) {
            this.addTuplizer(EntityMode.DOM4J, dom4jTuplizer);
        }
        if (!userSuppliedTuplizerImpls.isEmpty()) {
            Iterator itr = userSuppliedTuplizerImpls.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                EntityMode entityMode = (EntityMode)entry.getKey();
                String tuplizerClassName = (String)entry.getValue();
                EntityTuplizer tuplizer = entityTuplizerFactory.constructTuplizer(tuplizerClassName, em, mappedEntity);
                this.addTuplizer(entityMode, tuplizer);
            }
        }
    }
}

