/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.action.BeforeTransactionCompletionProcess;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.tools.Pair;

public class AuditProcess
implements BeforeTransactionCompletionProcess {
    private final RevisionInfoGenerator revisionInfoGenerator;
    private final LinkedList<AuditWorkUnit> workUnits;
    private final Queue<AuditWorkUnit> undoQueue;
    private final Map<Pair<String, Object>, AuditWorkUnit> usedIds;
    private Object revisionData;

    public AuditProcess(RevisionInfoGenerator revisionInfoGenerator) {
        this.revisionInfoGenerator = revisionInfoGenerator;
        this.workUnits = new LinkedList();
        this.undoQueue = new LinkedList<AuditWorkUnit>();
        this.usedIds = new HashMap<Pair<String, Object>, AuditWorkUnit>();
    }

    private void removeWorkUnit(AuditWorkUnit vwu) {
        this.workUnits.remove(vwu);
        if (vwu.isPerformed()) {
            this.undoQueue.offer(vwu);
        }
    }

    public void addWorkUnit(AuditWorkUnit vwu) {
        if (vwu.containsWork()) {
            Object entityId = vwu.getEntityId();
            if (entityId == null) {
                this.workUnits.offer(vwu);
            } else {
                String entityName = vwu.getEntityName();
                Pair<String, Object> usedIdsKey = Pair.make(entityName, entityId);
                if (this.usedIds.containsKey(usedIdsKey)) {
                    AuditWorkUnit other = this.usedIds.get(usedIdsKey);
                    AuditWorkUnit result = vwu.dispatch(other);
                    if (result != other) {
                        this.removeWorkUnit(other);
                        if (result != null) {
                            this.usedIds.put(usedIdsKey, result);
                            this.workUnits.offer(result);
                        }
                    }
                } else {
                    this.usedIds.put(usedIdsKey, vwu);
                    this.workUnits.offer(vwu);
                }
            }
        }
    }

    private void executeInSession(Session session) {
        AuditWorkUnit vwu;
        this.getCurrentRevisionData(session, true);
        while ((vwu = this.undoQueue.poll()) != null) {
            vwu.undo(session);
        }
        while ((vwu = this.workUnits.poll()) != null) {
            vwu.perform(session, this.revisionData);
        }
    }

    public Object getCurrentRevisionData(Session session, boolean persist) {
        if (this.revisionData == null) {
            this.revisionData = this.revisionInfoGenerator.generate();
        }
        if (!session.contains(this.revisionData) && persist) {
            this.revisionInfoGenerator.saveRevisionData(session, this.revisionData);
        }
        return this.revisionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBeforeTransactionCompletion(SessionImplementor session) {
        if (this.workUnits.size() == 0 && this.undoQueue.size() == 0) {
            return;
        }
        if (FlushMode.isManualFlushMode(session.getFlushMode())) {
            org.hibernate.classic.Session temporarySession = null;
            try {
                temporarySession = session.getFactory().openTemporarySession();
                this.executeInSession(temporarySession);
                temporarySession.flush();
            }
            finally {
                if (temporarySession != null) {
                    temporarySession.close();
                }
            }
        } else {
            this.executeInSession((Session)((Object)session));
            session.flush();
        }
    }
}

