/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.h2.query;

import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Conditions;

public class ColumnDefinitionImpl
implements ColumnDefinition {
    private String name = null;
    private Type type = null;
    private Specification[] specification = null;
    private boolean isWithDefaultValue = false;

    public String getDefinition() {
        String tempSpecif = "";
        String tempType = null;
        if (this.specification != null) {
            Specification[] specificationArray = this.specification;
            int n = this.specification.length;
            int n2 = 0;
            while (n2 < n) {
                Specification spec = specificationArray[n2];
                if (spec == Specification.AUTO_INCREMENT) {
                    tempType = "SERIAL";
                } else {
                    tempSpecif = String.valueOf(tempSpecif) + spec.getValue() + " ";
                }
                ++n2;
            }
        }
        if (tempType == null) {
            tempType = this.type.getTypeDefinition();
        }
        String defaultString = "";
        if (this.isWithDefaultValue) {
            String defaultValue = "";
            defaultValue = this.type.getInnerType().getDefaultValue() instanceof String ? "'" + Conditions.escapeSingleQuote((String)this.type.getInnerType().getDefaultValue().toString()) + "'" : this.type.getInnerType().getDefaultValue().toString();
            defaultString = "DEFAULT " + defaultValue + " ";
        }
        return String.valueOf(this.name) + " " + tempType + " " + defaultString + tempSpecif;
    }

    public String getLabel() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void setLabel(String label) {
        this.name = label;
    }

    public void setSpecification(Specification ... specifications) {
        if (this.type != null) {
            this.type.setAutoincrement(false);
            if (specifications != null) {
                Specification[] specificationArray = specifications;
                int n = specifications.length;
                int n2 = 0;
                while (n2 < n) {
                    Specification spec = specificationArray[n2];
                    if (spec == Specification.AUTO_INCREMENT) {
                        this.type.setAutoincrement(true);
                    }
                    if (spec == Specification.PRIMARY_KEY) {
                        this.type.setPrimaryKey(true);
                    }
                    ++n2;
                }
            }
        }
        this.specification = specifications;
    }

    public void setType(Type type) {
        if (this.specification != null) {
            Specification[] specificationArray = this.specification;
            int n = this.specification.length;
            int n2 = 0;
            while (n2 < n) {
                Specification spec = specificationArray[n2];
                if (spec == Specification.AUTO_INCREMENT) {
                    type.setAutoincrement(true);
                }
                ++n2;
            }
        }
        this.type = type;
    }

    public int compareTo(ColumnDefinition col) {
        return this.getLabel().compareTo(col.getLabel());
    }

    public void setWithDefaultValue(boolean defaultValue) {
        this.isWithDefaultValue = defaultValue;
    }

    public boolean isWithDefaultValue() {
        return this.isWithDefaultValue;
    }
}

