/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.request;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.gxrest.request.GXHTTP;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GXWebTargetAdapterRequest
implements GXHTTP<Entity<?>> {
    private WebTarget adaptee;
    private static final Logger logger = LoggerFactory.getLogger(GXWebTargetAdapterRequest.class);
    private String token;
    private String agent;
    private MediaType[] mediaType;

    public static GXWebTargetAdapterRequest newRequest(String address) {
        return new GXWebTargetAdapterRequest(address);
    }

    private GXWebTargetAdapterRequest(String address) {
        Client client = ClientBuilder.newClient();
        this.adaptee = client.target(address);
        this.token = SecurityTokenProvider.instance.get();
        this.agent = this.getClass().getSimpleName();
    }

    @Override
    public void setSecurityToken(String token) {
        this.token = token;
    }

    public GXWebTargetAdapterRequest from(String agent) {
        this.agent = agent;
        return this;
    }

    public GXWebTargetAdapterRequest configProperty(String name, String value) {
        this.adaptee = (WebTarget)this.adaptee.property(name, (Object)value);
        return this;
    }

    public GXWebTargetAdapterRequest register(Object component) {
        this.adaptee = (WebTarget)this.adaptee.register(component);
        return this;
    }

    public GXWebTargetAdapterRequest path(String path) throws UnsupportedEncodingException {
        this.adaptee = this.adaptee.path(path);
        return this;
    }

    public GXWebTargetAdapterRequest queryParams(Map<String, Object[]> parameters) throws UnsupportedEncodingException {
        if (Objects.nonNull(parameters) && !parameters.isEmpty()) {
            for (Map.Entry<String, Object[]> parameter : parameters.entrySet()) {
                this.adaptee = this.adaptee.queryParam(URLEncoder.encode(parameter.getKey(), "UTF-8"), parameter.getValue());
            }
        }
        return this;
    }

    public GXWebTargetAdapterRequest setAcceptedResponseType(MediaType ... acceptedResponseTypes) {
        this.mediaType = acceptedResponseTypes;
        return this;
    }

    @Override
    public GXInboundResponse delete() throws Exception {
        logger.trace("Sending a DELETE request...");
        Response response = this.buildRequest().delete();
        return this.buildGXResponse(response);
    }

    @Override
    public GXInboundResponse head() throws Exception {
        logger.trace("Sending a HEAD request...");
        Response response = this.buildRequest().head();
        return this.buildGXResponse(response);
    }

    @Override
    public GXInboundResponse get() throws Exception {
        logger.trace("Sending a GET request...");
        Response response = (Response)this.buildRequest().get(Response.class);
        return this.buildGXResponse(response);
    }

    private Invocation.Builder buildRequest() {
        Invocation.Builder builder = this.adaptee.request();
        builder.header("gcube-token", (Object)this.token);
        builder.header("User-Agent", (Object)this.agent);
        return builder;
    }

    @Override
    public GXInboundResponse put(Entity<?> body) throws Exception {
        Objects.requireNonNull(body, "Cannot send a PUT request with a null body.");
        logger.trace("Sending a PUT request...");
        Response response = this.buildRequest().put(body);
        return this.buildGXResponse(response);
    }

    @Override
    public GXInboundResponse post(Entity<?> body) throws Exception {
        Objects.requireNonNull(body, "Cannot send a POST request with a null body.");
        logger.trace("Sending a POST request...");
        Response response = (Response)this.buildRequest().post(body, Response.class);
        return this.buildGXResponse(response);
    }

    private GXInboundResponse buildGXResponse(Response source) {
        return Objects.nonNull(this.mediaType) ? new GXInboundResponse(source) : new GXInboundResponse(source, this.mediaType);
    }
}

