/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxhttp.reference;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GXConnection {
    public static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json;charset=UTF-8";
    public static final String PATH_SEPARATOR = "/";
    public static final String PARAM_STARTER = "?";
    public static final String PARAM_EQUALS = "=";
    public static final String PARAM_SEPARATOR = "&";
    public static final String UTF8 = "UTF-8";
    protected static final Logger logger = LoggerFactory.getLogger(GXConnection.class);
    protected final String address;
    protected String path = "";
    protected String agent;
    private String queryParameters;
    private String pathParameters;
    private String body;
    private InputStream bodyAsStream;
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean extCall = false;

    public GXConnection(String address) {
        this.address = address;
    }

    protected void addPath(String pathPart) throws UnsupportedEncodingException {
        if (this.path.compareTo("") != 0 && !this.path.endsWith(PATH_SEPARATOR)) {
            this.path = this.path + PATH_SEPARATOR;
        }
        this.path = this.path + Arrays.stream(pathPart.split(PATH_SEPARATOR)).map(part -> this.encodePart((String)part, true)).collect(Collectors.joining(PATH_SEPARATOR));
    }

    private String encodePart(String part, boolean path) {
        try {
            String encoded = URLEncoder.encode(part, UTF8);
            if (path) {
                encoded = encoded.replace("+", "%20");
            }
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            return part;
        }
    }

    private URL buildURL() throws MalformedURLException {
        URL url;
        StringWriter prepareURL = new StringWriter();
        prepareURL.append(this.address);
        Objects.requireNonNull(this.path, "Null path detected in the request!");
        if (this.address.endsWith(PATH_SEPARATOR)) {
            if (this.path.startsWith(PATH_SEPARATOR)) {
                this.path = this.path.substring(1);
            }
        } else if (!this.path.startsWith(PATH_SEPARATOR) && !this.path.isEmpty()) {
            prepareURL.append(PATH_SEPARATOR);
        }
        prepareURL.append(this.path);
        if (Objects.nonNull(this.pathParameters)) {
            prepareURL.append(this.pathParameters);
        }
        if (Objects.nonNull(this.queryParameters) && !this.queryParameters.isEmpty()) {
            prepareURL.append(PARAM_STARTER);
            prepareURL.append(this.queryParameters);
        }
        if ((url = new URL(prepareURL.toString())).getProtocol().compareTo("https") == 0) {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort(), url.getFile());
        }
        return url;
    }

    public HttpURLConnection send(HTTPMETHOD method) throws Exception {
        return this.send(this.buildURL(), method);
    }

    private HttpURLConnection addGCubeAuthorizationToken(HttpURLConnection uConn) throws Exception {
        if (!this.extCall) {
            String oldGcubeAuthToken;
            boolean authFound = false;
            String umaToken = AccessTokenProvider.instance.get();
            if (!Objects.isNull(umaToken) && !umaToken.isEmpty()) {
                uConn.setRequestProperty("Authorization", "Bearer " + umaToken);
                authFound = true;
            }
            if (!Objects.isNull(oldGcubeAuthToken = SecurityTokenProvider.instance.get()) && !oldGcubeAuthToken.isEmpty()) {
                uConn.setRequestProperty("gcube-token", oldGcubeAuthToken);
                authFound = true;
            }
            if (!authFound) {
                throw new IllegalStateException("The security token in the current environment is null.");
            }
        }
        return uConn;
    }

    private HttpURLConnection send(URL url, HTTPMETHOD method) throws Exception {
        DataOutputStream wr;
        HttpURLConnection uConn = (HttpURLConnection)url.openConnection();
        uConn = this.addGCubeAuthorizationToken(uConn);
        uConn.setDoOutput(true);
        if (this.agent != null) {
            uConn.setRequestProperty("User-Agent", this.agent);
        }
        for (String key : this.properties.keySet()) {
            uConn.setRequestProperty(key, this.properties.get(key));
        }
        uConn.setRequestMethod(method.toString());
        HttpURLConnection.setFollowRedirects(true);
        if (Objects.nonNull(this.body) && (method == HTTPMETHOD.POST || method == HTTPMETHOD.PUT)) {
            wr = new DataOutputStream(uConn.getOutputStream());
            wr.write(this.body.getBytes(UTF8));
            wr.flush();
            wr.close();
        }
        if (Objects.nonNull(this.bodyAsStream) && (method == HTTPMETHOD.POST || method == HTTPMETHOD.PUT)) {
            int len;
            wr = new DataOutputStream(uConn.getOutputStream());
            byte[] buffer = new byte[1024];
            while ((len = this.bodyAsStream.read(buffer)) > 0) {
                wr.write(buffer, 0, len);
            }
            wr.flush();
            wr.close();
        }
        int responseCode = uConn.getResponseCode();
        String responseMessage = uConn.getResponseMessage();
        logger.trace("{} {} : {} - {}", new Object[]{method, uConn.getURL(), responseCode, responseMessage});
        if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
            URL redirectURL = this.getURL(uConn.getHeaderField("Location"));
            logger.trace("{} is going to be redirected to {}", (Object)url.toString(), (Object)redirectURL.toString());
            return this.send(redirectURL, method);
        }
        return uConn;
    }

    private URL getURL(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        if (url.getProtocol().equals("https")) {
            url = new URL(url.getProtocol(), url.getHost(), url.getDefaultPort(), url.getFile());
        }
        return url;
    }

    protected void setAgent(String agent) {
        this.agent = agent;
    }

    public void setPathParameters(String parameters) {
        this.pathParameters = parameters;
    }

    public void setQueryParameters(String parameters) {
        this.queryParameters = parameters;
    }

    public void reset() {
        this.pathParameters = "";
        this.queryParameters = "";
        this.body = "";
    }

    public void addBody(String body) {
        if (!Objects.isNull(this.bodyAsStream)) {
            throw new IllegalArgumentException("Cannot set the input stream because addBodyAsStream(InputStream) was already invoked.");
        }
        this.body = body;
    }

    public void addBodyAsStream(InputStream bodyAsStream) {
        if (!Objects.isNull(this.body)) {
            throw new IllegalArgumentException("Cannot set the input stream because addBody(String) was already invoked.");
        }
        this.bodyAsStream = bodyAsStream;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void setExtCall(boolean extCall) {
        this.extCall = extCall;
    }

    public boolean isExtCall() {
        return this.extCall;
    }

    public static enum HTTPMETHOD {
        HEAD,
        GET,
        POST,
        PUT,
        DELETE,
        TRACE,
        PATCH,
        OPTIONS,
        CONNECT;


        public String toString() {
            return this.name();
        }
    }
}

