package org.gcube.common.gxhttp.reference;

/**
 * 
 * HTTP methods for requests.
 * 
 * @author Manuele Simi (ISTI-CNR)
 * @author Luca Frosini (ISTI-CNR)
 *
 * @param <BODY> the type of the body request
 * @param <RESPONSE> the type of the response

 */
public interface GXHTTP<BODY,RESPONSE> {
	
	/**
	 * Sends the PUT request to the web application.
	 * @param body the body of the request
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE put(BODY body) throws Exception;
	
	/**
	 * Sends the PUT request to the web application with no body.
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE put() throws Exception;
	
	/**
	 * Sends the DELETE request to the web application.
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE delete() throws Exception;
	
	/**
	 * Sends the PURGE request to the web application.
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE purge() throws Exception;

	/**
	 * Sends the HEAD request to the web application.
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE head() throws Exception;
	
	/**
	 * Sends the GET request to the web application.
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE get() throws Exception;

	/**
	 * Sends the POST request to the web application.
	 * @param body the body of the request
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE post(BODY body) throws Exception;
	
	/**
	 * Sends the POST request to the web application with no body.
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE post() throws Exception;
	
	/**
	 * Sends the TRACE request to the web application with no body.
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE trace() throws Exception;
	
	/**
	 * Sends the PATCH request to the web application.
	 * @param body the body of the request
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE patch(BODY body) throws Exception;

	/**
	 * Sends the PATCH request to the web application with no body.
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE patch() throws Exception;

	/**
	 * Sends the OPTIONS request to the web application with no body.
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE options() throws Exception;
	
	/**
	 * Sends the CONNECT request to the web application with no body.
	 * @return the response
	 * @throws Exception if an error occurs
	 */
	RESPONSE connect() throws Exception;


}
