/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.OperationNotSupportedException;
import org.geotools.data.Transaction;
import org.geotools.data.wfs.protocol.http.HttpMethod;
import org.geotools.data.wfs.v1_0_0.Action;
import org.geotools.data.wfs.v1_0_0.LogWriterDecorator;
import org.geotools.data.wfs.v1_0_0.TransactionResult;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.data.wfs.v1_0_0.xml.WFSSchema;
import org.geotools.filter.FidFilter;
import org.geotools.util.logging.Logging;
import org.geotools.xml.DocumentFactory;
import org.geotools.xml.DocumentWriter;
import org.geotools.xml.SchemaFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.xml.sax.SAXException;

public class WFSTransactionState
implements Transaction.State {
    private WFS_1_0_0_DataStore ds = null;
    private Map<String, String[]> fids = new HashMap<String, String[]>();
    Map<String, List<Action>> actionMap = new HashMap<String, List<Action>>();
    private long latestFid = Long.MAX_VALUE;
    private Transaction transaction;

    private WFSTransactionState() {
    }

    public WFSTransactionState(WFS_1_0_0_DataStore ds) {
        this.ds = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransaction(Transaction transaction) {
        if (transaction != null) {
            Map<String, List<Action>> map = this.actionMap;
            synchronized (map) {
                this.transaction = transaction;
                Map<String, String[]> map2 = this.fids;
                synchronized (map2) {
                    this.fids.clear();
                }
                this.actionMap.clear();
            }
        }
    }

    @Override
    public void addAuthorization(String AuthID) {
    }

    public String getLockId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        Map<String, List<Action>> copiedActions;
        TransactionResult transactionResult = null;
        Map<String, List<Action>> map = this.actionMap;
        synchronized (map) {
            this.combineActions();
            copiedActions = this.copy(this.actionMap);
        }
        for (Map.Entry<String, List<Action>> entry : copiedActions.entrySet()) {
            List<Action> actions = entry.getValue();
            String typeName = entry.getKey();
            if (actions.isEmpty()) continue;
            if (transactionResult == null) {
                try {
                    transactionResult = this.commitPost(actions);
                }
                catch (OperationNotSupportedException e) {
                    WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
                    transactionResult = null;
                }
                catch (SAXException e) {
                    WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
                    transactionResult = null;
                }
            }
            if (transactionResult == null) {
                throw new IOException("An error occured while committing.");
            }
            if (transactionResult.getStatus() == 2) {
                throw new IOException(transactionResult.getError().toString());
            }
            List<String> newFids = transactionResult.getInsertResult();
            int currentInsertIndex = 0;
            for (Action action : actions) {
                if (!(action instanceof Action.InsertAction)) continue;
                Action.InsertAction insertAction = (Action.InsertAction)action;
                if (currentInsertIndex >= newFids.size()) {
                    Logging.getLogger((String)"org.geotools.data.wfs").severe("Expected more fids to be returned by TransactionResponse!");
                    break;
                }
                String tempFid = insertAction.getFeature().getID();
                String finalFid = newFids.get(currentInsertIndex);
                this.ds.addFidMapping(tempFid, finalFid);
                ++currentInsertIndex;
            }
            Map<String, Object> map2 = this.fids;
            synchronized (map2) {
                this.fids.put(typeName, newFids.toArray(new String[0]));
            }
            if (currentInsertIndex != newFids.size()) {
                Logging.getLogger((String)"org.geotools.data.wfs").severe("number of fids inserted do not match number of fids returned by Transaction Response.  Got:" + newFids.size() + " expected: " + currentInsertIndex);
            }
            map2 = this.actionMap;
            synchronized (map2) {
                this.actionMap.get(typeName).removeAll(actions);
            }
        }
    }

    private Map<String, List<Action>> copy(Map<String, List<Action>> actionMap2) {
        HashMap<String, List<Action>> newMap = new HashMap<String, List<Action>>();
        for (Map.Entry<String, List<Action>> entry : actionMap2.entrySet()) {
            List<Action> list = entry.getValue();
            newMap.put(entry.getKey(), new ArrayList<Action>(list));
        }
        return newMap;
    }

    private TransactionResult commitPost(List<Action> toCommit) throws OperationNotSupportedException, IOException, SAXException {
        String commitMessageHandle;
        URL postUrl = this.ds.capabilities.getTransaction().getPost();
        if (postUrl == null) {
            throw new UnsupportedOperationException("Capabilities document does not describe a valid POST url for Transaction");
        }
        HttpURLConnection hc = this.ds.protocolHandler.getConnectionFactory().getConnection(postUrl, HttpMethod.POST);
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.put("DocumentWriter_BASE_ELEMENT", WFSSchema.getInstance().getElements()[24]);
        hints.put("DocumentWriter_ENCODING", this.ds.getDefaultEncoding());
        HashSet<String> fts = new HashSet<String>();
        for (Action a : toCommit) {
            fts.add(a.getTypeName());
        }
        HashSet<String> ns = new HashSet<String>();
        ns.add(WFSSchema.NAMESPACE.toString());
        for (String target : fts) {
            SimpleFeatureType schema = this.ds.getSchema(target);
            try {
                String namespaceURI = schema.getName().getNamespaceURI();
                ns.add(namespaceURI);
                URI namespaceLocation = this.ds.getDescribeFeatureTypeURL(target).toURI();
                SchemaFactory.getInstance(new URI(namespaceURI), namespaceLocation);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        hints.put("DocumentWriter_SCHEMA_ORDER", ns.toArray(new String[ns.size()]));
        OutputStream os = hc.getOutputStream();
        String encoding = this.ds.getDefaultEncoding();
        Writer w = new OutputStreamWriter(os, encoding);
        Logger logger = Logging.getLogger((String)"org.geotools.data.wfs");
        if (logger.isLoggable(Level.FINE)) {
            w = new LogWriterDecorator(w, logger, Level.FINE);
        }
        if ((logger = Logging.getLogger((String)"org.geotools.data.communication")).isLoggable(Level.FINE)) {
            w = new LogWriterDecorator(w, logger, Level.FINE);
        }
        if (this.transaction != null && this.transaction.getProperty("handle") instanceof String && (commitMessageHandle = (String)this.transaction.getProperty("handle")) != null) {
            hints.put("handle", commitMessageHandle);
        }
        DocumentWriter.writeDocument((Object)this, WFSSchema.getInstance(), w, hints);
        w.flush();
        w.close();
        InputStream is = this.ds.protocolHandler.getConnectionFactory().getInputStream(hc);
        hints = new HashMap();
        TransactionResult ft = (TransactionResult)DocumentFactory.getInstance(is, hints, Level.WARNING);
        return ft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        Map<String, List<Action>> map = this.actionMap;
        synchronized (map) {
            this.actionMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFids(String typeName) {
        Map<String, String[]> map = this.fids;
        synchronized (map) {
            return this.fids.get(typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(String typeName, Action a) {
        Map<String, List<Action>> map = this.actionMap;
        synchronized (map) {
            List<Action> list = this.actionMap.get(typeName);
            if (list == null) {
                list = new ArrayList<Action>();
                this.actionMap.put(typeName, list);
            }
            list.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> getActions(String typeName) {
        Map<String, List<Action>> map = this.actionMap;
        synchronized (map) {
            Collection collection = this.actionMap.get(typeName);
            if (collection == null || collection.isEmpty()) {
                return new ArrayList<Action>();
            }
            return new ArrayList<Action>(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> getAllActions() {
        Map<String, List<Action>> map = this.actionMap;
        synchronized (map) {
            ArrayList<Action> all = new ArrayList<Action>();
            for (List<Action> actions : this.actionMap.values()) {
                all.addAll(actions);
            }
            return all;
        }
    }

    protected void combineActions() {
        block0: for (List<Action> actions : this.actionMap.values()) {
            this.removeFilterAllActions(actions);
            Action.InsertAction firstAction = null;
            while (firstAction == null || !actions.contains(firstAction)) {
                firstAction = this.findFirstInsertAction(actions);
                if (firstAction == null) continue block0;
                this.processInsertAction(actions, firstAction);
            }
            Action.InsertAction current = this.findFirstInsertAction(actions);
            while (current != null && firstAction != current) {
                this.processInsertAction(actions, current);
                current = this.findFirstInsertAction(actions);
            }
        }
    }

    private void removeFilterAllActions(List<Action> actions) {
        Iterator<Action> iter = actions.iterator();
        while (iter.hasNext()) {
            Action element = iter.next();
            Filter filter = element.getFilter();
            if (!Filter.EXCLUDE.equals(filter)) continue;
            iter.remove();
        }
    }

    private Action.InsertAction findFirstInsertAction(List<Action> actions) {
        int i = 0;
        for (Action action : actions) {
            if (action instanceof Action.InsertAction) {
                return (Action.InsertAction)action;
            }
            ++i;
        }
        return null;
    }

    private void processInsertAction(List<Action> actions, Action.InsertAction action) {
        int indexOf = actions.indexOf(action);
        while (indexOf + 1 < actions.size() && indexOf != -1) {
            this.moveUpdateAndMoveInsertAction(actions, indexOf, action);
            indexOf = actions.indexOf(action);
        }
    }

    private void moveUpdateAndMoveInsertAction(List<Action> actions, int i, Action.InsertAction action) {
        if (i + 1 < actions.size()) {
            Action nextAction = actions.get(i + 1);
            if (nextAction instanceof Action.DeleteAction) {
                this.handleDeleteAction(actions, i, action, (Action.DeleteAction)nextAction);
            } else if (nextAction instanceof Action.UpdateAction) {
                this.handleUpdateAction(actions, i, action, (Action.UpdateAction)nextAction);
            } else {
                this.swap(actions, i);
            }
        }
    }

    private void handleDeleteAction(List<Action> actions, int i, Action.InsertAction action, Action.DeleteAction deleteAction) {
        if (deleteAction.getFilter().evaluate((Object)action.getFeature())) {
            actions.remove(i);
            if (deleteAction.getFilter() instanceof FidFilter && ((FidFilter)deleteAction.getFilter()).getFids().length == 1) {
                actions.remove(i);
            }
        } else {
            this.swap(actions, i);
        }
    }

    private int handleUpdateAction(List<Action> actions, int i, Action.InsertAction action, Action.UpdateAction updateAction) {
        if (updateAction.getFilter().evaluate((Object)action.getFeature())) {
            updateAction.update(action.getFeature());
            if (updateAction.getFilter() instanceof FidFilter && ((FidFilter)updateAction.getFilter()).getFids().length == 1) {
                actions.remove(i + 1);
                return i;
            }
        }
        this.swap(actions, i);
        return i + 1;
    }

    private void swap(List<Action> actions, int i) {
        Action item = actions.remove(i);
        actions.add(i + 1, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextFid(String typeName) {
        long fid;
        WFSTransactionState wFSTransactionState = this;
        synchronized (wFSTransactionState) {
            fid = this.latestFid--;
        }
        return "new" + typeName + "." + fid;
    }
}

