/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import java.util.HashSet;
import java.util.Map;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;

class UpdateFidFilterVisitor
extends DuplicatingFilterVisitor {
    private Map<String, String> fidMap;

    public UpdateFidFilterVisitor(Map<String, String> fidMap) {
        this.fidMap = fidMap;
    }

    public Object visit(Id filter, Object extraData) {
        HashSet<FeatureId> fidSet = new HashSet<FeatureId>();
        for (Identifier identifier : filter.getIdentifiers()) {
            String target = (String)identifier.getID();
            String fid = this.getFinalFid(target);
            fidSet.add(this.ff.featureId(fid));
        }
        return this.ff.id(fidSet);
    }

    public synchronized String getFinalFid(String fid) {
        String finalFid = this.fidMap.get(fid);
        if (finalFid == null) {
            return fid;
        }
        return finalFid;
    }
}

