/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface;

import java.util.ArrayList;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.bean.CswLayersResult;
import org.gcube.common.geoserverinterface.bean.CswRecord;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.bean.MetadataInfo;
import org.gcube.common.geoserverinterface.engine.GeonetworkGetMethods;
import org.gcube.common.geoserverinterface.engine.GeonetworkPutMethods;
import org.gcube.common.geoserverinterface.geonetwork.GeoserverDiscovery;
import org.gcube.common.geoserverinterface.geonetwork.MostUnLoadGeoserver;
import org.gcube.common.geoserverinterface.geonetwork.RandomGeoserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeonetworkCaller {
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private HttpMethodCall HMC = null;
    private GeonetworkGetMethods geonetworkGetMethods = null;
    private GeonetworkPutMethods geonetworkPutMethods = null;
    private String username = null;
    private String password = null;
    private boolean isLogged = false;
    private GeoserverDiscovery geoDiscovery = null;
    private final String suffixGeonetworkServices = "/srv/en";

    public GeonetworkCaller(String geonetworkUrl, String user, String password) {
        geonetworkUrl = String.valueOf(geonetworkUrl) + "/srv/en";
        this.HMC = new HttpMethodCall(this.connectionManager, geonetworkUrl, "", "");
        this.username = user;
        this.password = password;
        this.instanceCallers();
        this.loginGeonetwork(user, password);
    }

    public void loadGeoserverDiscovery() {
        try {
            this.geoDiscovery = new GeoserverDiscovery(this.getHarvestings());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void instanceCallers() {
        this.geonetworkGetMethods = new GeonetworkGetMethods(this.HMC);
        this.geonetworkPutMethods = new GeonetworkPutMethods(this.HMC);
    }

    public GeonetworkGetMethods getGeonetworkGetMethods() {
        return this.geonetworkGetMethods;
    }

    public GeonetworkPutMethods getGeonetworkPutMethods() {
        return this.geonetworkPutMethods;
    }

    private String loginGeonetwork(String username, String password) {
        String res = null;
        if (this.isLogged) {
            this.logoutGeonetwork();
        }
        try {
            res = this.HMC.CallPost("xml.user.login", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><request><username>" + username + "</username>" + "<password>" + password + "</password>" + "</request>", "text/xml");
        }
        catch (Exception e) {
            this.isLogged = false;
            e.printStackTrace();
        }
        this.isLogged = true;
        return res;
    }

    public String logoutGeonetwork() {
        String res = null;
        if (this.isLogged) {
            try {
                res = this.HMC.CallPost("xml.user.logout", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><requests/>", "application/xml");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.isLogged = false;
        }
        return res;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getIsLogged() {
        return this.isLogged;
    }

    public ArrayList<String> getOrderedListOfGeoserver(GeonetworkCommonResourceInterface.GeoserverMethodResearch method, GeonetworkCommonResourceInterface.GeoserverType serverType) {
        ArrayList<Object> orderList = null;
        if (!this.isLogged) {
            this.loginGeonetwork(this.username, this.password);
        }
        if (this.geoDiscovery == null) {
            this.loadGeoserverDiscovery();
        }
        try {
            if (method.compareTo(GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD) == 0) {
                this.geoDiscovery.setSorter(new MostUnLoadGeoserver());
            } else {
                this.geoDiscovery.setSorter(new RandomGeoserver());
            }
            orderList = new ArrayList();
            if (serverType.compareTo(GeonetworkCommonResourceInterface.GeoserverType.WMS) == 0) {
                orderList = this.geoDiscovery.sortGeoserver(this.geoDiscovery.getWmsGeoserverList());
            } else if (serverType.compareTo(GeonetworkCommonResourceInterface.GeoserverType.WFS) == 0) {
                orderList = this.geoDiscovery.sortGeoserver(this.geoDiscovery.getWfsGeoserverList());
            }
            System.out.println("\nOrdered List of " + (Object)((Object)serverType) + " Geoserver:");
            for (String string : orderList) {
                System.out.println(string);
            }
            System.out.println("\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return orderList;
    }

    public String getHarvestings() throws Exception {
        if (this.isLogged) {
            return this.geonetworkGetMethods.getListHarvestings();
        }
        throw new Exception("You must be logged");
    }

    public String getMetadataByFileIdentifier(String uuid) throws Exception {
        if (this.isLogged) {
            return this.geonetworkGetMethods.getMetadataByFileIdentifier(uuid);
        }
        throw new Exception("You must be logged");
    }

    public String getMetadataById(String id) throws Exception {
        if (this.isLogged) {
            return this.geonetworkGetMethods.getMetadataById(id);
        }
        throw new Exception("You must be logged");
    }

    public String searchLayerByTitleIsLike(String title) throws Exception {
        if (this.isLogged) {
            return this.geonetworkGetMethods.searchLayerByTitleIsLike(title);
        }
        throw new Exception("You must be logged");
    }

    public String searchLayerByAnyText(String anyText, int maxRecords) throws Exception {
        if (this.isLogged) {
            return this.geonetworkGetMethods.searchLayerByAnyText(anyText, maxRecords);
        }
        throw new Exception("You must be logged");
    }

    public ArrayList<CswRecord> getCswRecordsBySearch(String anyText, int maxRecords) throws Exception {
        if (this.isLogged) {
            return this.geonetworkGetMethods.getCswRecordsBySearch(anyText, maxRecords);
        }
        throw new Exception("You must be logged");
    }

    public String searchLayerByTitleIsEqualTo(String title) throws Exception {
        if (this.isLogged) {
            return this.geonetworkGetMethods.searchLayerByTitleIsEqualTo(title);
        }
        throw new Exception("You must be logged");
    }

    public String getHarvestingById(String id) throws Exception {
        if (this.isLogged) {
            return this.geonetworkGetMethods.getHarvestingById(id);
        }
        throw new Exception("You must be logged");
    }

    public String getGeonetInfoBySearchService(String title, GeonetworkCommonResourceInterface.GeonetworkCategory category, Boolean similarity) throws Exception {
        if (this.isLogged) {
            return this.geonetworkGetMethods.searchService(title, category, similarity);
        }
        throw new Exception("You must be logged");
    }

    public String insertMetadata(String fileIdentifier, String workspace, String layerTitle, String layerName, String description, GeonetworkCommonResourceInterface.GeonetworkCategory category, String geoServerWmsUrl) throws Exception {
        if (this.isLogged) {
            return this.geonetworkPutMethods.insertMetadata(fileIdentifier, workspace, layerTitle, layerName, description, category, geoServerWmsUrl);
        }
        throw new Exception("You must be logged");
    }

    public String insertMetadata(MetadataInfo metadataInfo) throws Exception {
        if (this.isLogged) {
            return this.geonetworkPutMethods.insertMetadata(metadataInfo);
        }
        throw new Exception("You must be logged");
    }

    public String insertMetadataByFeatureType(FeatureTypeRest featureTypeRest, GeonetworkCommonResourceInterface.GeonetworkCategory category, String geoServerWmsUrl) throws Exception {
        if (this.isLogged) {
            return this.geonetworkPutMethods.insertMetadataByFeatureType(featureTypeRest, category, geoServerWmsUrl);
        }
        throw new Exception("You must be logged");
    }

    public String insertMetadataByCswTransaction(String fileIdentifier, String workspace, String layerTitle, String layerName, String description, String geoServerWmsUrl) throws Exception {
        if (this.isLogged) {
            return this.geonetworkPutMethods.insertMetadataByCswTransaction(fileIdentifier, workspace, layerTitle, layerName, description, geoServerWmsUrl);
        }
        throw new Exception("You must be logged");
    }

    public String updateHarvesting(String id) throws Exception {
        if (this.isLogged) {
            return this.geonetworkPutMethods.updateHarvesting(id);
        }
        throw new Exception("You must be logged");
    }

    public String deleteMetadataById(String id) throws Exception {
        if (this.isLogged) {
            return this.geonetworkPutMethods.deleteMetadataById(id);
        }
        throw new Exception("You must be logged");
    }

    public CswLayersResult getLayersFromCsw(int startPosition, int maxRecords, boolean sortByTitle, boolean sortAscendent, GeoCaller.FILTER_TYPE filter, String textToSearch) {
        if (!this.isLogged) {
            this.loginGeonetwork(this.username, this.password);
        }
        return this.geonetworkGetMethods.getLayersFromCsw(startPosition, maxRecords, sortByTitle, sortAscendent, filter, textToSearch);
    }
}

