/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.GeometryTransformation;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.capability.FunctionName;

public class FilterFunction_offset
extends FunctionExpressionImpl
implements GeometryTransformation {
    public static FunctionName NAME = new FunctionNameImpl("offset", "geometry", "offsetX", "offsetY");

    public FilterFunction_offset() {
        super("offset");
        this.functionName = NAME;
    }

    @Override
    public int getArgCount() {
        return 3;
    }

    @Override
    public Object evaluate(Object feature) {
        Double offsetY;
        Geometry geom = (Geometry)this.getExpression(0).evaluate(feature, Geometry.class);
        Double offsetX = (Double)this.getExpression(1).evaluate(feature, Double.class);
        if (offsetX == null) {
            offsetX = 0.0;
        }
        if ((offsetY = (Double)this.getExpression(2).evaluate(feature, Double.class)) == null) {
            offsetY = 0.0;
        }
        if (geom != null) {
            Geometry offseted = (Geometry)geom.clone();
            offseted.apply((CoordinateSequenceFilter)new OffsetOrdinateFilter(offsetX, offsetY));
            return offseted;
        }
        return null;
    }

    @Override
    public ReferencedEnvelope invert(ReferencedEnvelope renderingEnvelope) {
        Double offsetX = (Double)this.getExpression(1).evaluate(null, Double.class);
        Double offsetY = (Double)this.getExpression(2).evaluate(null, Double.class);
        if (offsetX != null && offsetY != null) {
            ReferencedEnvelope offseted = new ReferencedEnvelope(renderingEnvelope);
            offseted.translate(offsetX, offsetY);
            return offseted;
        }
        return null;
    }

    public static class OffsetOrdinateFilter
    implements CoordinateSequenceFilter {
        double offsetX;
        double offsetY;

        public OffsetOrdinateFilter(double offsetX, double offsetY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public void filter(CoordinateSequence seq, int i) {
            seq.setOrdinate(i, 0, seq.getOrdinate(i, 0) + this.offsetX);
            seq.setOrdinate(i, 1, seq.getOrdinate(i, 1) + this.offsetY);
        }

        public boolean isDone() {
            return false;
        }

        public boolean isGeometryChanged() {
            return true;
        }
    }
}

