/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;

public class FilterFunction_numberFormat2
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("numberFormat2", "format", "number", "minus", "decimal", "seperator");

    public FilterFunction_numberFormat2() {
        super("numberFormat2");
        this.functionName = NAME;
    }

    @Override
    public int getArgCount() {
        return 5;
    }

    @Override
    public Object evaluate(Object feature) {
        Double number;
        String format;
        try {
            format = (String)this.getExpression(0).evaluate(feature, String.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function dateFormat argument #0 - expected type String");
        }
        try {
            number = (Double)this.getExpression(1).evaluate(feature, Double.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function dateFormat argument #1 - expected type java.util.Date");
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        if (this.params.size() > 2) {
            Character neg = (Character)this.getExpression(2).evaluate(feature, Character.class);
            symbols.setMinusSign(neg.charValue());
        }
        if (this.params.size() > 3) {
            Character dec = (Character)this.getExpression(3).evaluate(feature, Character.class);
            symbols.setDecimalSeparator(dec.charValue());
        }
        if (this.params.size() > 4) {
            Character grp = (Character)this.getExpression(4).evaluate(feature, Character.class);
            symbols.setGroupingSeparator(grp.charValue());
        }
        DecimalFormat numberFormat = new DecimalFormat(format, symbols);
        return numberFormat.format(number);
    }
}

