/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.metadata;

import java.util.Collection;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicDescription;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.SpatialTemporalExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.test.Assert;
import org.opengis.test.ValidatorContainer;
import org.opengis.test.metadata.MetadataValidator;

public class ExtentValidator
extends MetadataValidator {
    public ExtentValidator(ValidatorContainer validatorContainer) {
        super(validatorContainer, "org.opengis.metadata.extent");
    }

    public void dispatch(GeographicExtent geographicExtent) {
        if (geographicExtent instanceof GeographicBoundingBox) {
            this.validate((GeographicBoundingBox)geographicExtent);
        } else if (geographicExtent instanceof BoundingPolygon) {
            this.validate((BoundingPolygon)geographicExtent);
        } else if (geographicExtent instanceof GeographicDescription) {
            this.validate((GeographicDescription)geographicExtent);
        }
    }

    public void validate(GeographicDescription geographicDescription) {
        if (geographicDescription == null) {
            return;
        }
        Identifier identifier = geographicDescription.getGeographicIdentifier();
        this.mandatory("GeographicDescription: must have an identifier.", identifier);
    }

    public void validate(BoundingPolygon boundingPolygon) {
        if (boundingPolygon == null) {
            return;
        }
    }

    public void validate(GeographicBoundingBox geographicBoundingBox) {
        if (geographicBoundingBox == null) {
            return;
        }
        double d = geographicBoundingBox.getWestBoundLongitude();
        double d2 = geographicBoundingBox.getEastBoundLongitude();
        double d3 = geographicBoundingBox.getSouthBoundLatitude();
        double d4 = geographicBoundingBox.getNorthBoundLatitude();
        Assert.assertBetween("GeographicBoundingBox: illegal west bound.", -180.0, 180.0, d);
        Assert.assertBetween("GeographicBoundingBox: illegal east bound.", -180.0, 180.0, d2);
        Assert.assertBetween("GeographicBoundingBox: illegal south bound.", -90.0, 90.0, d3);
        Assert.assertBetween("GeographicBoundingBox: illegal north bound.", -90.0, 90.0, d4);
        Assert.assertTrue((String)"GeographicBoundingBox: invalid range of longitudes.", (d <= d2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"GeographicBoundingBox: invalid range of latitudes.", (d3 <= d4 ? 1 : 0) != 0);
    }

    public void validate(VerticalExtent verticalExtent) {
        if (verticalExtent == null) {
            return;
        }
        Double d = verticalExtent.getMinimumValue();
        Double d2 = verticalExtent.getMaximumValue();
        this.mandatory("VerticalExtent: must have a minimum value.", d);
        this.mandatory("VerticalExtent: must have a maximum value.", d2);
        if (d != null && d2 != null) {
            Assert.assertTrue((String)"VerticalExtent: invalid range.", (d <= d2 ? 1 : 0) != 0);
        }
    }

    public void validate(TemporalExtent temporalExtent) {
        if (temporalExtent == null) {
            return;
        }
        if (temporalExtent instanceof SpatialTemporalExtent) {
            SpatialTemporalExtent spatialTemporalExtent = (SpatialTemporalExtent)temporalExtent;
            Collection<? extends GeographicExtent> collection = spatialTemporalExtent.getSpatialExtent();
            this.mandatory("SpatialTemporalExtent: must contains spatial extent.", collection);
            if (collection != null) {
                for (GeographicExtent geographicExtent : collection) {
                    Assert.assertNotNull((String)"SpatialTemporalExtent: getSpatialExtent() can't contain null element.", (Object)geographicExtent);
                    this.dispatch(geographicExtent);
                }
            }
        }
    }

    public void validate(Extent extent) {
        if (extent == null) {
            return;
        }
        this.validateOptional(extent.getDescription());
        this.validateCollection(GeographicExtent.class, extent.getGeographicElements());
        this.validateCollection(VerticalExtent.class, extent.getVerticalElements());
        this.validateCollection(TemporalExtent.class, extent.getTemporalElements());
    }
}

