/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.geometry;

import java.util.Arrays;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.test.Assert;
import org.opengis.test.Validator;
import org.opengis.test.ValidatorContainer;

public class GeometryValidator
extends Validator {
    public double tolerance = 1.0E-6;

    public GeometryValidator(ValidatorContainer validatorContainer) {
        super(validatorContainer, "org.opengis.geometry");
    }

    public void validate(Envelope envelope) {
        Object object;
        if (envelope == null) {
            return;
        }
        int n = envelope.getDimension();
        Assert.assertPositive("Envelope: dimension can't be negative.", n);
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        this.container.crs.dispatch(coordinateReferenceSystem);
        DirectPosition directPosition = envelope.getLowerCorner();
        this.validate(directPosition);
        this.mandatory("Envelope: must have a lower corner.", directPosition);
        if (directPosition != null) {
            Assert.assertEquals((String)"Envelope: lower corner dimension must be equals to the envelope dimension.", (long)n, (long)directPosition.getDimension());
            if (coordinateReferenceSystem != null && (object = directPosition.getCoordinateReferenceSystem()) != null) {
                Assert.assertSame((String)"Envelope: lower CRS must be the same than the envelope CRS.", (Object)coordinateReferenceSystem, (Object)object);
            }
        }
        object = envelope.getUpperCorner();
        this.validate((DirectPosition)object);
        this.mandatory("Envelope: must have a upper corner.", object);
        if (object != null) {
            CoordinateReferenceSystem coordinateReferenceSystem2;
            Assert.assertEquals((String)"Envelope: upper corner dimension must be equals to the envelope dimension.", (long)n, (long)object.getDimension());
            if (coordinateReferenceSystem != null && (coordinateReferenceSystem2 = object.getCoordinateReferenceSystem()) != null) {
                Assert.assertSame((String)"Envelope: upper CRS must be the same than the envelope CRS.", (Object)coordinateReferenceSystem, (Object)coordinateReferenceSystem2);
            }
        }
        for (int i = 0; i < n; ++i) {
            double d = envelope.getMinimum(i);
            double d2 = envelope.getMaximum(i);
            if (directPosition != null) {
                Assert.assertEquals((String)"Envelope: minimum value must be equals to the lower corner ordinate.", (double)directPosition.getOrdinate(i), (double)d, (double)0.0);
            }
            if (object != null) {
                Assert.assertEquals((String)"Envelope: maximum value must be equals to the upper corner ordinate.", (double)object.getOrdinate(i), (double)d2, (double)0.0);
            }
            if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                Assert.assertValidRange("Envelope: invalid minimum and maximum ordinate values.", d, d2);
            }
            double d3 = d2 - d;
            double d4 = d3 * this.tolerance;
            Assert.assertEquals((String)"Envelope: unexpected span value.", (double)d3, (double)envelope.getSpan(i), (double)d4);
            Assert.assertEquals((String)"Envelope: unexpected median value.", (double)((d2 + d) / 2.0), (double)envelope.getMedian(i), (double)d4);
        }
    }

    public void validate(DirectPosition directPosition) {
        if (directPosition == null) {
            return;
        }
        int n = directPosition.getDimension();
        Assert.assertPositive("DirectPosition: dimension can't be negative.", n);
        double[] dArray = directPosition.getCoordinate();
        this.mandatory("DirectPosition: coordinate array can't be null.", dArray);
        if (dArray != null) {
            Assert.assertEquals((String)"DirectPosition: coordinate array length must be equals to the dimension.", (long)n, (long)dArray.length);
            for (int i = 0; i < n; ++i) {
                Assert.assertEquals((String)"DirectPosition: getOrdinate(i) must be the same than coordinate[i].", (double)dArray[i], (double)directPosition.getOrdinate(i), (double)0.0);
            }
        }
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        this.container.crs.dispatch(coordinateReferenceSystem);
        int n2 = 0;
        if (coordinateReferenceSystem != null) {
            CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            if (coordinateSystem != null) {
                Assert.assertEquals((String)"DirectPosition: CRS dimension must matches the position dimension.", (long)n, (long)coordinateSystem.getDimension());
                for (int i = 0; i < n; ++i) {
                    CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
                    if (coordinateSystemAxis == null) continue;
                    double d = dArray[i];
                    double d2 = coordinateSystemAxis.getMinimumValue();
                    double d3 = coordinateSystemAxis.getMaximumValue();
                    double d4 = (d3 - d2) * this.tolerance;
                    Assert.assertBetween("DirectPosition: ordinate out of axis bounds.", d2 - d4, d3 + d4, d);
                }
            }
            n2 = coordinateReferenceSystem.hashCode();
        }
        Assert.assertEquals((String)"DirectPosition: hashCode must be compliant to the contract given in javadoc.", (long)(n2 += Arrays.hashCode(dArray)), (long)((Object)directPosition).hashCode());
        Assert.assertTrue((String)"DirectPosition: must be equals to itself.", (boolean)((Object)directPosition).equals(directPosition));
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            int n3 = i;
            dArray[n3] = dArray[n3] * 2.0;
            Assert.assertEquals((String)"DirectPosition: coordinate array must be cloned.", (double)d, (double)directPosition.getOrdinate(i), (double)0.0);
        }
    }
}

