/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.net.URI;
import javax.xml.namespace.QName;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.kml.KML;
import org.geotools.kml.bindings.StyleMap;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureTypeBinding
extends AbstractComplexBinding {
    protected static final SimpleFeatureType featureType;
    StyleMap styleMap;

    public FeatureTypeBinding(StyleMap styleMap) {
        this.styleMap = styleMap;
    }

    @Override
    public QName getTarget() {
        return KML.FeatureType;
    }

    @Override
    public Class getType() {
        return SimpleFeature.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        b.set("name", node.getChildValue("name"));
        b.set("visibility", node.getChildValue("visibility", (Object)Boolean.TRUE));
        b.set("open", node.getChildValue("open", (Object)Boolean.TRUE));
        b.set("address", node.getChildValue("address"));
        b.set("phoneNumber", node.getChildValue("phoneNumber"));
        b.set("description", node.getChildValue("description"));
        b.set("LookAt", node.getChildValue("LookAt"));
        URI uri = (URI)node.getChildValue("styleUrl");
        if (uri != null) {
            b.set("Style", (Object)this.styleMap.get(uri));
        }
        b.set("Region", node.getChildValue("Region"));
        return b.buildFeature((String)node.getAttributeValue("id"));
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        if (object instanceof FeatureCollection) {
            FeatureCollection features = (FeatureCollection)object;
            if ("id".equals(name.getLocalPart())) {
                return features.getID();
            }
        }
        if (object instanceof SimpleFeature) {
            URI uri;
            SimpleFeature feature = (SimpleFeature)object;
            if ("id".equals(name.getLocalPart())) {
                return feature.getID();
            }
            if ("name".equals(name.getLocalPart())) {
                return feature.getAttribute("name");
            }
            if ("description".equals(name.getLocalPart())) {
                return feature.getAttribute("description");
            }
            if (KML.styleUrl.equals(name) && (uri = (URI)feature.getAttribute("Style")) != null) {
                return this.styleMap.get(uri);
            }
        }
        return super.getProperty(object, name);
    }

    static {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setNamespaceURI("http://earth.google.com/kml/2.1");
        tb.setName("feature");
        tb.add("name", String.class);
        tb.add("visibility", Boolean.class);
        tb.add("open", Boolean.class);
        tb.add("address", String.class);
        tb.add("phoneNumber", String.class);
        tb.add("description", String.class);
        tb.add("LookAt", Coordinate.class);
        tb.add("Style", FeatureTypeStyle.class);
        tb.add("Region", Envelope.class);
        featureType = tb.buildFeatureType();
    }
}

