/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.spec.KeySpec;
import java.util.Arrays;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Objects;
import org.gcube.io.jsonwebtoken.security.Password;

public class PasswordSpec
implements Password,
KeySpec {
    private static final String NONE_ALGORITHM = "NONE";
    private static final String DESTROYED_MSG = "Password has been destroyed. Password character array may not be obtained.";
    private static final String ENCODED_DISABLED_MSG = "getEncoded() is disabled for Password instances as they are intended to be used with key derivation algorithms only. Because passwords rarely have the length or entropy necessary for secure cryptographic operations such as authenticated hashing or encryption, they are disabled as direct inputs for these operations to help avoid accidental misuse; if you see this exception message, it is likely that the associated Password instance is being used incorrectly.";
    private volatile boolean destroyed;
    private final char[] password;

    public PasswordSpec(char[] password) {
        this.password = Assert.notEmpty((char[])password, (String)"Password character array cannot be null or empty.");
    }

    private void assertActive() {
        if (this.destroyed) {
            throw new IllegalStateException(DESTROYED_MSG);
        }
    }

    public char[] toCharArray() {
        this.assertActive();
        return (char[])this.password.clone();
    }

    public String getAlgorithm() {
        return NONE_ALGORITHM;
    }

    public String getFormat() {
        return null;
    }

    public byte[] getEncoded() {
        throw new UnsupportedOperationException(ENCODED_DISABLED_MSG);
    }

    public void destroy() {
        this.destroyed = true;
        Arrays.fill(this.password, '\u0000');
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public int hashCode() {
        return Objects.nullSafeHashCode((char[])this.password);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PasswordSpec) {
            PasswordSpec other = (PasswordSpec)obj;
            return Objects.nullSafeEquals((Object)this.password, (Object)other.password);
        }
        return false;
    }

    public final String toString() {
        return "<redacted>";
    }
}

