package org.gcube.event.publisher;

import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConductorResultsParser implements ResultsParser {

    protected static final Logger logger = LoggerFactory.getLogger(ConductorResultsParser.class);

    public ConductorResultsParser() {
    }

    @Override
    public EventStatus parseResults(JSONObject results) {
        EventStatus eventStatus = null;
        if (results != null) {
            JSONObject input = (JSONObject) results.get("input");
            JSONObject output = (JSONObject) results.get("output");
            switch ((String) results.get("status")) {
            case "COMPLETED":
                eventStatus = EventStatus.COMPLETED(input, output);
                break;
            case "FAILED":
                eventStatus = EventStatus.FAILED(input, output);
                break;
            case "NOT_FOUND":
                eventStatus = EventStatus.NOT_FOUND();
                break;
            case "PAUSED":
                eventStatus = EventStatus.PAUSED(input);
                break;
            case "RUNNING":
                eventStatus = EventStatus.RUNNING(input);
                break;
            case "TERMINATED":
                eventStatus = EventStatus.TERMINATED(input, output);
                break;
            default:
                eventStatus = EventStatus.NOT_FOUND();
            }
        } else {
            logger.warn("Nothing to parse since JSON object is null");
        }
        return eventStatus;
    }

}
