package org.gcube.common.iam;

import java.util.List;

import org.gcube.common.keycloak.model.TokenResponse;

/**
 * Abstract base class for D4Science IAM client authentication responses.
 * Provides functionality for obtaining authorization after successful authentication.
 * 
 * @author Mauro Mugnaini (Nubisware S.r.l.)
 */
public abstract class D4ScienceIAMClientAuthn extends AbstractIAMResponse {

    /**
     * Creates a new authentication response.
     * 
     * @param iamClient the D4Science IAM client instance
     * @param tokenResponse the token response from authentication
     */
    public D4ScienceIAMClientAuthn(D4ScienceIAMClient iamClient, TokenResponse tokenResponse) {
        super(iamClient, tokenResponse);
    }

    /**
     * Authorizes the client or the user by using the authn already obtained, for the specific context audience and no optional permissions.
     * @param context the requested token context audience (e.g. a specific context or another client)
     * @return the authz object
     * @throws D4ScienceIAMClientException if an error occurs during authz process
     */
    public D4ScienceIAMClientAuthz authorize(String context) throws D4ScienceIAMClientException {
        return authorize(context, null);
    }

    /**
     * Authorizes the client or the user by using the authn already obtained, for the specific context audience and with optional permissions.
     * @param context the requested token context audience (e.g. a specific context or another client)
     * @param permissions the optional permissions
     * @return the authz object
     * @throws D4ScienceIAMClientException if an error occurs during authz process
     */
    public D4ScienceIAMClientAuthz authorize(String context, List<String> permissions)
            throws D4ScienceIAMClientException {

        return new D4ScienceIAMClientAuthz(this, context, permissions);
    }

}