/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.iam;

import java.net.URL;
import org.gcube.common.iam.AbstractIAMResponse;
import org.gcube.common.iam.D4ScienceIAMClient;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.keycloak.model.TokenResponse;

public class OIDCBearerAuth
extends AbstractIAMResponse {
    protected OIDCBearerAuth(D4ScienceIAMClient iamClient, TokenResponse tokenResponse) {
        super(iamClient, tokenResponse);
    }

    public static OIDCBearerAuth fromAuthorizationHeader(String authorizationHeader) {
        return OIDCBearerAuth.fromBearerAuthorization(authorizationHeader);
    }

    public static OIDCBearerAuth fromBearerAuthorization(String bearerAuthorization) {
        return OIDCBearerAuth.fromAccessTokenString(bearerAuthorization.replace("bearer ", ""));
    }

    public static OIDCBearerAuth fromAccessTokenString(String accessToken) {
        TokenResponse tr = new TokenResponse();
        tr.setAccessToken(accessToken);
        try {
            return new OIDCBearerAuth(D4ScienceIAMClient.newInstance(new URL(ModelUtils.getAccessTokenFrom((TokenResponse)tr).getIssuer())), tr);
        }
        catch (Exception e) {
            return null;
        }
    }
}

