package org.gcube.common.quota.library.quotedefault;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.common.quota.library.quotalist.AccessType;
import org.gcube.common.quota.library.quotalist.CallerType;
import org.gcube.common.quota.library.quotalist.QuotaType;
import org.gcube.common.quota.library.quotalist.TimeInterval;


@XmlRootElement(name = "ServiceQuotaDefault")
@XmlAccessorType(XmlAccessType.FIELD)
public class ServiceQuotaDefault extends QuotaDefault {

	private CallerType callerType;	
	private TimeInterval timeInterval;
	private Double quotaValue;
	
	//TODO eliminare il pacchetto e lasciare come quote di default per is ervizi senza specificare il pacchetto 
	private Long  servicePackageId;
	private AccessType  accessType;
	
	protected ServiceQuotaDefault(){}
	
	
	
	@Override
	public QuotaType getQuotaType() {
		return QuotaType.SERVICE;
	}

	@Override
	public String getQuotaAsString() {
		return this.callerType+","+this.servicePackageId.toString()+","+this.timeInterval.toString()+","+this.quotaValue+","+this.accessType;
		
	}

	@Override
	public CallerType getCallerType() {
		return callerType;
	}
	
	public void setCallerType(CallerType callerType) {
		this.callerType = callerType;
	}
	
	@Override
	public TimeInterval getTimeInterval() {		
		return timeInterval;
	}
	public void setTimeInterval(TimeInterval timeInterval) {
		this.timeInterval = timeInterval;
	}

	public Double getQuotaValue() {
		return quotaValue;
	}
	public void setQuotaValue(Double quotaValue) {
		this.quotaValue = quotaValue;
	}
	
	public Long getServicePackageId() {
		return servicePackageId;
	}
	public void setServicePackageId(Long servicePackageId) {
		this.servicePackageId = servicePackageId;
	}

	public AccessType getAccessType() {
		return accessType;
	}

	public void setAccessType(AccessType accessType) {
		this.accessType = accessType;
	}

	@Override
	public String toString() {
		return "ServiceQuotaDefault [callerType=" + callerType + ", timeInterval="
				+ timeInterval + ", quotaValue=" + quotaValue
				+ ", servicePackageId=" + servicePackageId + ", typeAccess="
				+ accessType +"]";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((accessType == null) ? 0 : accessType.hashCode());
		result = prime * result
				+ ((callerType == null) ? 0 : callerType.hashCode());
		result = prime * result
				+ ((quotaValue == null) ? 0 : quotaValue.hashCode());
		result = prime
				* result
				+ ((servicePackageId == null) ? 0 : servicePackageId.hashCode());
		result = prime * result
				+ ((timeInterval == null) ? 0 : timeInterval.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ServiceQuotaDefault other = (ServiceQuotaDefault) obj;
		if (accessType != other.accessType)
			return false;
		if (callerType != other.callerType)
			return false;
		if (quotaValue == null) {
			if (other.quotaValue != null)
				return false;
		} else if (!quotaValue.equals(other.quotaValue))
			return false;
		if (servicePackageId == null) {
			if (other.servicePackageId != null)
				return false;
		} else if (!servicePackageId.equals(other.servicePackageId))
			return false;
		if (timeInterval != other.timeInterval)
			return false;
		return true;
	}



	


	

	
	
}
