package org.gcube.common.quota.library.quotedefault;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

import org.gcube.common.quota.library.quotalist.CallerType;
import org.gcube.common.quota.library.quotalist.QuotaType;
import org.gcube.common.quota.library.quotalist.TimeInterval;

/**
 *
 * @author Alessandro Pieve at ISTI-CNR 
 * (alessandro.pieve@isti.cnr.it)
 * ex: 
 * <Quota>
 *  	<Quotatype>STORAGE</type>
 *   	<callerType>USER</callerType>
 *      <timeInterval>DAILY</timeInterval>
 *      <quotaValue>100.0</quotaValue>
 *   </Storage>
 * </Quota>
 */


@XmlSeeAlso({ServiceQuotaDefault.class, StorageQuotaDefault.class})
public abstract class QuotaDefault {
	
	protected QuotaDefault() {}
		
	public abstract QuotaType getQuotaType();
	
	public abstract String getQuotaAsString();
	
	public abstract CallerType getCallerType();
		
	public abstract TimeInterval getTimeInterval();
	
	public abstract Double getQuotaValue();

}
