/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.secret;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.ExternalServiceInfo;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.authorization.utils.clientid.RenewalProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.authorization.utils.user.KeycloakUser;
import org.gcube.common.authorization.utils.user.User;
import org.gcube.common.iam.OIDCBearerAuth;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTSecret
extends Secret {
    private static final Logger logger = LoggerFactory.getLogger(JWTSecret.class);
    public static final long TOLERANCE = TimeUnit.MILLISECONDS.toMillis(200L);
    protected RenewalProvider renewalProvider;
    protected Set<String> roles;
    protected ClientInfo clientInfo;
    protected Caller caller;
    protected String context;
    protected OIDCBearerAuth oidcBearerAuth;

    public JWTSecret(String token) {
        super(10, token);
        this.oidcBearerAuth = OIDCBearerAuth.fromAccessTokenString((String)token);
    }

    private String getTokenString() {
        try {
            boolean expired = this.isExpired();
            long now = Calendar.getInstance().getTimeInMillis();
            long expireTime = this.oidcBearerAuth.getAccessToken().getExp() * 1000L;
            long expireWithTolerance = expireTime - TOLERANCE;
            if (!expired && now >= expireWithTolerance) {
                expired = true;
            }
            if (expired && this.renewalProvider != null) {
                try {
                    JWTSecret renewed = (JWTSecret)this.renewalProvider.renew(this.getContext());
                    this.token = renewed.token;
                }
                catch (Exception e) {
                    logger.warn("Unable to renew the token with the RenewalProvider. I'll continue using the old token.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error in the procedure to evaluate/refresh the current token. I'll continue using the old token.", (Throwable)e);
        }
        return this.token;
    }

    @Override
    public void setToken() throws Exception {
        AccessTokenProvider.instance.set(this.getTokenString());
    }

    @Override
    public void resetToken() throws Exception {
        AccessTokenProvider.instance.reset();
    }

    protected Set<String> getRoles() throws Exception {
        if (this.roles == null) {
            this.roles = this.oidcBearerAuth.getRoles();
        }
        return this.roles;
    }

    @Override
    public ClientInfo getClientInfo() throws Exception {
        if (this.clientInfo == null) {
            User user = this.getUser();
            this.clientInfo = user.isApplication() ? new ExternalServiceInfo(user.getUsername(), "unknown") : new UserInfo(user.getUsername(), new ArrayList<String>(user.getRoles()), user.getEmail(), user.getGivenName(), user.getFamilyName());
        }
        return this.clientInfo;
    }

    @Override
    public Caller getCaller() throws Exception {
        if (this.caller == null) {
            this.caller = new Caller(this.getClientInfo(), "token");
        }
        return this.caller;
    }

    @Override
    public String getContext() throws Exception {
        if (this.context == null) {
            String[] audience;
            for (String aud : audience = this.oidcBearerAuth.getAccessToken().getAudience()) {
                if (aud == null || aud.compareTo("") == 0) continue;
                try {
                    String contextToBeValidated = URLDecoder.decode(aud, StandardCharsets.UTF_8.toString());
                    ScopeBean scopeBean = new ScopeBean(contextToBeValidated);
                    this.context = scopeBean.toString();
                    return this.context;
                }
                catch (Exception e) {
                    logger.error("Invalid context name for audience {} in access token. Trying next one if any.", (Object)aud, (Object)e);
                }
            }
            throw new Exception("Invalid context in access token");
        }
        return this.context;
    }

    @Override
    public String getUsername() throws Exception {
        return this.oidcBearerAuth.getAccessToken().getPreferredUsername();
    }

    @Override
    public Map<String, String> getHTTPAuthorizationHeaders() {
        HashMap<String, String> authorizationHeaders = new HashMap<String, String>();
        authorizationHeaders.put("Authorization", "Bearer " + this.getTokenString());
        return authorizationHeaders;
    }

    public void setRenewalProvider(RenewalProvider renewalProvider) {
        this.renewalProvider = renewalProvider;
    }

    @Override
    public boolean isExpired() throws Exception {
        return this.oidcBearerAuth.isExpired();
    }

    @Override
    public boolean isRefreshable() throws Exception {
        return this.oidcBearerAuth.canBeRefreshed();
    }

    @Override
    public User getUser() {
        if (this.user == null) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                String accessTokenString = objectMapper.writeValueAsString((Object)this.oidcBearerAuth.getAccessToken());
                this.user = (User)objectMapper.readValue(accessTokenString, KeycloakUser.class);
                this.user.setRoles(this.getRoles());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.user;
    }
}

