/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.clientid;

import org.gcube.common.authorization.utils.clientid.RenewalProvider;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.iam.D4ScienceIAMClient;
import org.gcube.common.iam.D4ScienceIAMClientAuthn;

public class ClientIDManager
implements RenewalProvider {
    protected final String clientId;
    protected final String clientSecret;
    protected D4ScienceIAMClientAuthn d4ScienceIAMClientAuthn;

    public ClientIDManager(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    private JWTSecret getJWTSecret(D4ScienceIAMClientAuthn d4ScienceIAMClientAuthn) {
        String accessToken = d4ScienceIAMClientAuthn.getAccessTokenString();
        JWTSecret jwtSecret = new JWTSecret(accessToken);
        jwtSecret.setRenewalProvider(this);
        return jwtSecret;
    }

    public Secret getSecret(String context) throws Exception {
        D4ScienceIAMClient iamClient = D4ScienceIAMClient.newInstance((String)context);
        this.d4ScienceIAMClientAuthn = iamClient.authenticate(this.clientId, this.clientSecret, context);
        return this.getJWTSecret(this.d4ScienceIAMClientAuthn);
    }

    @Override
    public Secret renew(String context) throws Exception {
        if (this.d4ScienceIAMClientAuthn != null && this.d4ScienceIAMClientAuthn.canBeRefreshed()) {
            this.d4ScienceIAMClientAuthn.refresh(this.clientId, this.clientSecret);
            return this.getJWTSecret(this.d4ScienceIAMClientAuthn);
        }
        return this.getSecret(context);
    }
}

