/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.manager;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gcube.common.authorization.utils.manager.SecretHolder;
import org.gcube.common.authorization.utils.provider.SecretProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.authorization.utils.secret.SecretUtility;
import org.gcube.common.authorization.utils.user.User;

public class SecretManager {
    private SecretHolder initialSecretHolder;
    private SecretHolder currentSecretHolder;

    public SecretManager() {
        this.currentSecretHolder = this.initialSecretHolder = new SecretHolder();
    }

    public synchronized void addSecretViaProvider(SecretProvider secretProvider) {
        if (this.currentSecretHolder != this.initialSecretHolder) {
            throw new RuntimeException("You can't add a Secret in a session. You must terminate the session first.");
        }
        Secret secret = secretProvider.getSecret();
        this.currentSecretHolder.addSecret(secret);
    }

    public synchronized void addSecret(Secret secret) {
        if (this.currentSecretHolder != this.initialSecretHolder) {
            throw new RuntimeException("You can't add a Secret in a session. You must terminate the session first.");
        }
        this.currentSecretHolder.addSecret(secret);
    }

    public synchronized void startSession(Secret secret) throws Exception {
        if (this.currentSecretHolder != this.initialSecretHolder) {
            throw new RuntimeException("You are already in a session. You must terminate the session first.");
        }
        this.initialSecretHolder.reset();
        this.currentSecretHolder = new SecretHolder(secret);
        this.currentSecretHolder.set();
    }

    public synchronized void startSession(Collection<Secret> secrets) throws Exception {
        if (this.currentSecretHolder != this.initialSecretHolder) {
            throw new RuntimeException("You are already in a session. You must terminate the session first.");
        }
        this.initialSecretHolder.reset();
        this.currentSecretHolder = new SecretHolder(secrets);
        this.currentSecretHolder.set();
    }

    public synchronized void startSession(SecretHolder secretHolder) throws Exception {
        if (this.currentSecretHolder != this.initialSecretHolder) {
            throw new RuntimeException("You are already in a session. You must terminate the session first.");
        }
        this.initialSecretHolder.reset();
        this.currentSecretHolder = secretHolder;
        this.currentSecretHolder.set();
    }

    public synchronized void endSession() {
        if (this.currentSecretHolder != this.initialSecretHolder) {
            this.currentSecretHolder.reset();
            try {
                this.initialSecretHolder.set();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.currentSecretHolder = this.initialSecretHolder;
        }
    }

    public synchronized void set() throws Exception {
        if (this.currentSecretHolder != this.initialSecretHolder) {
            throw new Exception("You are in a session. You must terminate the session first.");
        }
        this.currentSecretHolder.set();
    }

    public synchronized void reset() {
        this.currentSecretHolder.reset();
        if (this.initialSecretHolder != this.currentSecretHolder) {
            this.initialSecretHolder.reset();
        }
    }

    public synchronized String getContext() {
        return this.currentSecretHolder.getContext();
    }

    public synchronized User getUser() {
        return this.currentSecretHolder.getUser();
    }

    public synchronized SecretHolder getCurrentSecretHolder() {
        SecretHolder secretHolder = new SecretHolder();
        TreeSet<Secret> secrets = new TreeSet<Secret>();
        SortedSet<Secret> originalSecrets = this.currentSecretHolder.getSecrets();
        for (Secret s : originalSecrets) {
            Secret secret = SecretUtility.getSecretByTokenString(s.getToken());
            secrets.add(secret);
        }
        secretHolder.addSecrets(secrets);
        return secretHolder;
    }
}

