package org.gcube.common.authorization.utils.user;

import java.util.Collection;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.common.keycloak.model.AccessToken;

/**
 * @author Luca Frosini (ISTI-CNR)
 */
public class KeycloakUser extends AccessToken implements User {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -7083648026885406300L;

	@Override
	@JsonIgnore
	public String getUsername() {
		return getId();
	}

	@Override
	@JsonIgnore
	public Collection<String> getRoles() {
		return getRealmAccess().getRoles();
	}

	@Override
	public String getAbout() {
		return "";
	}

}
