package org.gcube.common.authorization.utils.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.gcube.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class GCubeUser implements User {
	
	/**
	 * Used to allow to have any additional properties
	 */
	@JsonIgnore
	protected Map<String, Object> additionalProperties;
	
	public GCubeUser() {
		this.additionalProperties = new HashMap<>();
		
		// This info are not always present. Setting an empty string to avoid null
		this.givenName = "";
		this.familyName = "";
		this.eMail = "";
		this.jobTitle = "";
		this.picture = "";
		this.middleName = "";
	}
	
	@JsonProperty("id")
	protected String username;
	@JsonProperty("roles")
	protected Set<String> roles;
	
	@JsonProperty("given_name")
	protected String givenName;
	@JsonProperty("family_name")
	protected String familyName;
	@JsonProperty("email")
	protected String eMail;
	@JsonProperty("job_title")
	protected String jobTitle;
	
	@JsonProperty("picture")
	protected String picture;
	@JsonProperty("middle_name")
	protected String middleName;
	
	@Override
	public String getUsername() {
		return username;
	}
	
	public void setUsername(String username) {
		this.username = username;
	}

	@Override
	public Collection<String> getRoles() {
		return roles;
	}
	
	public void setRoles(Set<String> roles) {
		this.roles = roles;
	}
	@Override
	public String getGivenName() {
		return givenName;
	}
	
	@Override
	public String getFamilyName() {
		return familyName;
	}
	
	@Override
	public String getEmail() {
		return eMail;
	}

	@Override
	public String getAbout() {
		return jobTitle;
	}
	
	public String getPicture() {
		return picture;
	}

	public String getMiddleName() {
		return middleName;
	}
	
	@JsonAnyGetter
	public Map<String, Object> getAdditionalProperties() {
		return additionalProperties;
	}

	public void setAdditionalProperties(Map<String, Object> additionalProperties) {
		this.additionalProperties = additionalProperties;
	}

	public Object getAdditionalProperty(String key) {
		return additionalProperties.get(key);
	}

	@JsonAnySetter
	public void setAdditionalProperty(String key, Object value) {
		this.additionalProperties.put(key, value);
	}

}
