package org.gcube.common.authorization.utils.provider;

import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.authorization.utils.secret.JWTSecret;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class JWTSecretProvider implements SecretProvider {

	@Override
	public Secret getSecret() {
		String token = AccessTokenProvider.instance.get();
		if(token!=null) {
			return new JWTSecret(token);
		}
		return null; 
	}

}
