/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice.configuration;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorizationservice.configuration.AuthorizationConfiguration;
import org.gcube.common.authorizationservice.configuration.AuthorizationRule;

public class ConfigurationBuilder {
    List<AuthorizationRule> rules = new ArrayList();
    List<String> ips = new ArrayList();
    String accountingDir = null;

    public static ConfigurationBuilder getBuilder() {
        return new ConfigurationBuilder();
    }

    public ConfigurationBuilder rule(AuthorizationRule rule) {
        this.rules.add(rule);
        return this;
    }

    public ConfigurationBuilder accountingDir(String accountingDir) {
        this.accountingDir = accountingDir;
        return this;
    }

    public ConfigurationBuilder autoConfirmedIp(String ip) {
        this.ips.add(ip);
        return this;
    }

    public AuthorizationConfiguration build() {
        AuthorizationConfiguration configuration = new AuthorizationConfiguration();
        configuration.setAuthorizationRules(this.rules);
        configuration.setAllowedContainerIps(this.ips);
        if (this.accountingDir != null) {
            configuration.setAccountingDir(this.accountingDir);
        }
        return configuration;
    }
}

