/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice;

import java.util.UUID;
import javax.annotation.ManagedBean;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.QualifiersList;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.common.authorizationservice.util.TokenPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="apikey")
@ManagedBean
public class ApiKeyManager {
    private static final Logger log = LoggerFactory.getLogger(ApiKeyManager.class);
    @Inject
    TokenPersistence persistence;

    @PUT
    @Consumes(value={"application/xml"})
    public String generateApiKey(@QueryParam(value="qualifier") String qualifier, @Context HttpServletRequest req) {
        CalledMethodProvider.instance.set("generate(APIKEY)");
        try {
            AuthorizationEntry info = (AuthorizationEntry)req.getAttribute("authorizationInfo");
            if (qualifier == null || qualifier.isEmpty() || qualifier.equals("TOKEN")) {
                throw new IllegalArgumentException();
            }
            log.info("generator called with user {} in context {} ", (Object)info.getClientInfo(), (Object)info.getContext());
            if (info.getClientInfo().getId().split(":").length > 1) {
                throw new Exception("invalid user id: " + info.getClientInfo());
            }
            String token = this.persistence.getExistingToken(info.getClientInfo().getId(), info.getContext(), qualifier);
            if (token == null) {
                token = UUID.randomUUID().toString();
                this.persistence.saveAuthorizationEntry(token, info.getContext(), info.getClientInfo(), qualifier, info.getClientInfo().getId());
            }
            return token;
        }
        catch (Exception e) {
            log.error("error generating apikey ", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error Generating ApiKey: " + e.getMessage())).type("text/plain").build());
        }
    }

    @GET
    @Produces(value={"application/xml"})
    public QualifiersList retrieveApiKeys(@Context HttpServletRequest req) {
        CalledMethodProvider.instance.set("retrieve(APIKEY)");
        log.info("calling getApiKey");
        try {
            AuthorizationEntry info = (AuthorizationEntry)req.getAttribute("authorizationInfo");
            return new QualifiersList(this.persistence.getExistingApiKeys(info.getClientInfo().getId(), info.getContext()));
        }
        catch (Exception e) {
            log.error("error retrieving apikey", (Throwable)e);
            return null;
        }
    }

    @Path(value="{key}")
    @DELETE
    public void removeApiKey(@PathParam(value="key") String key, @Context HttpServletRequest req) {
    }
}

