/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.discovery.urlFilter;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import org.apache.log4j.Logger;

public class UrlFilter {
    private static final Logger logger = Logger.getLogger(UrlFilter.class);
    private static HashMap<String, String> filetypes = null;
    private static HashMap<String, String> knownTypes = new HashMap();

    public static Collection<String> getRequestedMimeTypes() {
        return filetypes.values();
    }

    public static boolean isUrl(String str) {
        return str.matches("http://(.)+") || str.matches("https://(.)+") || str.matches("www\\.(.)+");
    }

    public static String getMimeType(String resourceURL) throws InterruptedException, IOException {
        URL url = null;
        try {
            url = new URL(resourceURL);
        }
        catch (MalformedURLException mue) {
            logger.info((Object)"Error getting mime type", (Throwable)mue);
            return null;
        }
        HttpURLConnection.setFollowRedirects(true);
        Thread.sleep(UrlFilter.getSleepTime());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("HEAD");
        conn = UrlFilter.openConnectionCheckRedirects(conn);
        conn.setConnectTimeout(120000);
        int statusCode = conn.getResponseCode();
        if (statusCode == 503) {
            logger.debug((Object)("WARNING: Url " + resourceURL + " reported status code 503. Please increase the crawler's sleep time."));
            conn.disconnect();
            return null;
        }
        if (conn.getResponseCode() >= 400) {
            logger.debug((Object)("WARNING: Url " + resourceURL + " seems to be unreachable. If this url is not of importance you can ignore this error."));
            conn.disconnect();
            return null;
        }
        String mimeType = conn.getContentType();
        logger.debug((Object)("mime type for " + resourceURL + ": " + mimeType));
        logger.debug((Object)("response code was: " + statusCode));
        conn.disconnect();
        return mimeType;
    }

    private static long getSleepTime() {
        int rand = UrlFilter.rand(1, 5);
        int toReturn = rand * 1000;
        if (toReturn == 0) {
            toReturn = 1000;
        }
        return toReturn;
    }

    public static int rand(int lo, int hi) {
        int n = hi - lo + 1;
        Random rn = new Random();
        int i = rn.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }

    public static boolean checkExtension(String url) {
        for (String type : filetypes.keySet()) {
            if (!url.matches("(.)+\\." + type)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkMimeTypeProvided(String mimeType) {
        return filetypes.containsValue(mimeType);
    }

    public static boolean checkMimeType(String url) throws IOException, InterruptedException {
        String mimeType = UrlFilter.getMimeType(url);
        return filetypes.containsValue(mimeType);
    }

    public static String resolveRedirections(String resourceURL) throws IOException, InterruptedException {
        HttpURLConnection.setFollowRedirects(true);
        Thread.sleep(UrlFilter.getSleepTime());
        URL url = new URL(resourceURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("HEAD");
        conn = UrlFilter.openConnectionCheckRedirects(conn);
        conn.setConnectTimeout(120000);
        int statusCode = conn.getResponseCode();
        if (statusCode == 503) {
            logger.warn((Object)("WARNING: Url " + resourceURL + " reported status code 503. Please increase the crawler's sleep time."));
            conn.disconnect();
            return null;
        }
        if (conn.getResponseCode() >= 400) {
            logger.warn((Object)("WARNING: Url " + resourceURL + " seems to be unreachable. If this url is not of importance you can ignore this error."));
            conn.disconnect();
            return null;
        }
        String ret = conn.getURL().toExternalForm();
        logger.debug((Object)("resolved url: " + ret));
        conn.disconnect();
        return ret;
    }

    private static HttpURLConnection openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        do {
            HttpURLConnection http;
            int stat;
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new IOException("Redirection should be allowed only for HTTP and HTTPS and should be limited to 5 redirections at most.");
            }
            redir = true;
            c = target.openConnection();
            c.setConnectTimeout(120000);
            ++redirects;
        } while (redir);
        return (HttpURLConnection)c;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(UrlFilter.isUrl(args[0]));
        System.out.println(UrlFilter.checkExtension(args[0]));
        String type = UrlFilter.getMimeType(args[0]);
        System.out.println(type);
        System.out.println(UrlFilter.checkMimeType(type));
    }

    static {
        knownTypes.put("xls", "application/excel");
        knownTypes.put("doc", "application/word");
        knownTypes.put("dot", "application/word");
        knownTypes.put("pdf", "application/pdf");
        knownTypes.put("ai", "application/postscript");
        knownTypes.put("eps", "application/postscript");
        knownTypes.put("ps", "application/postscript");
        knownTypes.put("ppt", "application/powerpoint");
        knownTypes.put("pps", "application/powerpoint");
        knownTypes.put("rtf", "application/rtf");
        knownTypes.put("zip", "application/zip");
        knownTypes.put("bmp", "image/bmp");
        knownTypes.put("gif", "image/gif");
        knownTypes.put("jpg", "image/jpeg");
        knownTypes.put("jpeg", "image/jpeg");
        knownTypes.put("jpe", "image/jpeg");
        knownTypes.put("png", "image/png");
        knownTypes.put("tif", "image/tiff");
        knownTypes.put("tiff", "image/tiff");
        filetypes = new HashMap();
        filetypes.put("pdf", knownTypes.get("pdf"));
    }
}

