/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.discovery.crawler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Vector;
import net.matuschek.http.DownloadRuleSet;
import net.matuschek.http.HttpDocManager;
import net.matuschek.http.HttpException;
import net.matuschek.http.URLLogger;
import net.matuschek.spider.WebRobot;
import org.apache.log4j.Logger;
import org.gcube.resource.discovery.urlFilter.UrlFilter;

public class Configs {
    private static final Logger logger = Logger.getLogger(Configs.class);
    public static String agentName = "JoBo";
    public static boolean ignoreRobotsTxt = false;
    public static int sleepTime = 3000;
    public static int maxDepth = 1;
    public static boolean walkToOtherHosts = false;
    public static boolean allowWholeHost = false;
    public static boolean allowWholeDomain = false;
    public static boolean flexibleHostCheck = true;
    public static boolean localizeLinks = false;
    public static boolean enableCookies = false;
    public static String startReferer = null;
    public static int maxDocumentAge = -1;
    public static String[] allowedUrl = null;
    public static String[] visitMany = null;
    public static String proxy = null;
    public static int bandwidth = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readXMLDoc(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(Configs.class.getResourceAsStream(filename)));
        String strLine = null;
        StringBuilder builder = new StringBuilder();
        try {
            while ((strLine = br.readLine()) != null) {
                builder.append(strLine);
            }
        }
        finally {
            br.close();
        }
        return builder.toString();
    }

    public static void configureCrawlerForValidation(WebRobot crawler) throws IOException {
        logger.debug((Object)"Configuring crawler for validation");
        crawler.setAgentName("Validator");
        crawler.setIgnoreRobotsTxt(false);
        crawler.setSleepTime(1);
        crawler.setMaxDepth(1);
        crawler.setWalkToOtherHosts(false);
        crawler.setAllowWholeHost(true);
        crawler.setAllowWholeDomain(true);
        crawler.setFlexibleHostCheck(true);
        crawler.setEnableCookies(true);
        DownloadRuleSet rules = new DownloadRuleSet();
        int minSize = 1;
        int maxSize = 0x6400000;
        rules.addRule("text", "html", minSize, maxSize, true);
        Collection<String> mimeTypes = UrlFilter.getRequestedMimeTypes();
        for (String mimeType : mimeTypes) {
            String[] parts = mimeType.split("/");
            if (parts.length < 2) {
                logger.debug((Object)("WARNING: Requested mimetype " + mimeType + " seems to be malformed"));
                throw new IOException();
            }
            rules.addRule(parts[0], parts[1], minSize, maxSize, true);
        }
        rules.addRule("*", "*", minSize, maxSize, false);
        crawler.setDownloadRuleSet(rules);
    }

    public static void configureCrawler(WebRobot crawler) throws IOException, HttpException {
        int i;
        Vector<String> urls;
        logger.debug((Object)"Configuring crawler using configuration file parameters");
        crawler.setAgentName(agentName);
        crawler.setIgnoreRobotsTxt(ignoreRobotsTxt);
        crawler.setSleepTime(sleepTime / 1000);
        crawler.setMaxDepth(maxDepth);
        crawler.setWalkToOtherHosts(walkToOtherHosts);
        crawler.setAllowWholeHost(allowWholeHost);
        crawler.setAllowWholeDomain(allowWholeDomain);
        crawler.setFlexibleHostCheck(flexibleHostCheck);
        crawler.setEnableCookies(enableCookies);
        if (startReferer != null) {
            crawler.setStartReferer(startReferer);
        }
        if (maxDocumentAge > 0) {
            crawler.setMaxDocumentAge((long)maxDocumentAge);
        }
        if (allowedUrl != null) {
            urls = new Vector<String>();
            for (i = 0; i < allowedUrl.length; ++i) {
                urls.add(allowedUrl[i]);
            }
            crawler.setAllowedURLs(urls);
        }
        if (visitMany != null) {
            urls = new Vector();
            for (i = 0; i < visitMany.length; ++i) {
                urls.add(visitMany[i]);
            }
            crawler.setVisitMany(urls);
        }
        if (proxy != null) {
            crawler.setProxy(proxy);
        }
        if (bandwidth > 0) {
            crawler.setBandwidth(bandwidth);
        }
        DownloadRuleSet rules = new DownloadRuleSet();
        int minSize = 1;
        int maxSize = 0x6400000;
        rules.addRule("text", "html", minSize, maxSize, true);
        Collection<String> mimeTypes = UrlFilter.getRequestedMimeTypes();
        for (String mimeType : mimeTypes) {
            String[] parts = mimeType.split("/");
            if (parts.length < 2) {
                logger.debug((Object)("WARNING: Requested mimetype " + mimeType + " seems to be malformed"));
                throw new IOException();
            }
            rules.addRule(parts[0], parts[1], minSize, maxSize, true);
        }
        rules.addRule("*", "*", minSize, maxSize, false);
        crawler.setDownloadRuleSet(rules);
    }

    public static void main(String[] args) {
        WebRobot robby = new WebRobot();
        try {
            Configs.configureCrawler(robby);
            StringWriter sw = new StringWriter();
            URLLogger log = new URLLogger((Writer)sw);
            robby.setDocManager((HttpDocManager)log);
            robby.run();
            logger.debug((Object)sw.getBuffer().toString());
        }
        catch (Exception e) {
            logger.debug((Object)e.getLocalizedMessage());
        }
    }
}

